/* proc2.cプログラム　   */
/* 対話的処理プログラム  */
/* (2) 入出力と簡単な処理*/

#include <stdio.h>

#define N 4096 /*処理対象データの上限数*/

/*関数のプロトタイプの宣言　*/
void printmenu() ;/*メニュー表示*/

int datainput(int data[]) ;/*データの読み込み*/
void dataoutput(int data[],int n) ;/*データの出力*/
void search(int data[],int n) ;/*データ検索*/

/*main()関数*/
int main()
{
 int cmd ;/*コマンドを保持*/
 int data[N] ;/* 処理対象データ*/
 int n ;/*処理対象データの個数*/

 /*オープニングメッセージ*/
 printf("対話的処理プログラムproc2.c\n\n") ;

 /*コマンド入力と処理の繰り返し*/
 printmenu() ;/*メニュー表示*/
 while(scanf("%d",&cmd)!=EOF){
  switch (cmd) {
   case 1:
      n=datainput(data) ;/*データの読み込み*/
      break ;
   case 2:
      dataoutput(data,n) ;/*データの出力*/
      break ;
   case 3:
      search(data,n) ;/*データ検索*/
      break ;
   default :
      printf("コマンドエラー\n\n") ;
  } 
  printmenu() ;/*メニュー表示*/
 } 


}

/* printmenu()関数*/
/* メニュー表示   */
void printmenu() 
{
 printf("処理メニュー\n") ;
 printf(" 1:データ入力\n") ;
 printf(" 2:データ出力\n") ;
 printf(" 3:データ検索\n") ;
 printf("\n(ctrl-Dで終了)\n\n") ;
}

/*datainput()関数 */
/*データの読み込み*/
int datainput(int data[])
{
 int n=0 ;/*データ数*/

 printf("1:データ入力\n") ;
 /*標準入力からの読み込み*/
 while(scanf("%d",&data[n])!=EOF)
  ++ n ;

 printf("データ数:%d個\n\n",n) ;

 return n ;
}


/*dataoutput()関数 */
/*データの出力*/
void dataoutput(int data[],int n)
{
 int i ;/*繰り返しの制御*/

 printf("2:データ出力\n") ;
 for(i=0;i<n;++i)
  printf("%d:%d\n",i,data[i]) ;

 printf("\n") ;
}


/*search()関数 */
/*データの検索*/
void search(int data[],int n)
{
 int i ;/*繰り返しの制御*/
 int target ;/*検索対象の数値*/

 printf("3:データ検索\n") ;
 printf("検索対象の数値は？\n") ;
 scanf("%d",&target) ;

 for(i=0;i<n;++i)
  if(target==data[i])
   printf("発見　%d:%d\n",i,data[i]) ;

 printf("\n") ;

}


