/* proc3.cプログラム　   */
/* 対話的処理プログラム  */
/* (3) 計算とグラフ描画  */

#include <stdio.h>
#include <math.h>

#define N 4096 /*処理対象データの上限数*/
#define WIDTH 20 /*グラフ描画の最大幅（文字数）*/

/*関数のプロトタイプの宣言　*/
void printmenu() ;/*メニュー表示*/

int datainput(int data[]) ;/*データの読み込み*/
void dataoutput(int data[],int n) ;/*データの出力*/
void search(int data[],int n) ;/*データ検索*/
void calc(int data[],int n) ;/*平均・標準偏差の計算*/
void graph(int data[],int n) ;/*グラフ描画*/

/*main()関数*/
int main()
{
 int cmd ;/*コマンドを保持*/
 int data[N] ;/* 処理対象データ*/
 int n ;/*処理対象データの個数*/

 /*オープニングメッセージ*/
 printf("対話的処理プログラムproc3.c\n\n") ;

 /*コマンド入力と処理の繰り返し*/
 printmenu() ;/*メニュー表示*/
 while(scanf("%d",&cmd)!=EOF){
  switch (cmd) {
   case 1:
      n=datainput(data) ;/*データの読み込み*/
      break ;
   case 2:
      dataoutput(data,n) ;/*データの出力*/
      break ;
   case 3:
      search(data,n) ;/*データ検索*/
      break ;
   case 4:
      calc(data,n) ;/*平均・標準偏差の計算*/
      break ;
   case 5:
      graph(data,n) ;/*グラフ描画*/
      break ;
   default :
      printf("コマンドエラー\n\n") ;
  } 
  printmenu() ;/*メニュー表示*/
 } 


}

/* printmenu()関数*/
/* メニュー表示   */
void printmenu() 
{
 printf("処理メニュー\n") ;
 printf(" 1:データ入力\n") ;
 printf(" 2:データ出力\n") ;
 printf(" 3:データ検索\n") ;
 printf(" 4:平均・標準偏差\n") ;
 printf(" 5:グラフ描画\n") ;
 printf("\n(ctrl-Dで終了)\n\n") ;
}

/*datainput()関数 */
/*データの読み込み*/
int datainput(int data[])
{
 int n=0 ;/*データ数*/

 printf("1:データ入力\n") ;
 /*標準入力からの読み込み*/
 while(scanf("%d",&data[n])!=EOF)
  ++ n ;

 printf("データ数:%d個\n\n",n) ;

 return n ;
}


/*dataoutput()関数 */
/*データの出力*/
void dataoutput(int data[],int n)
{
 int i ;/*繰り返しの制御*/

 printf("2:データ出力\n") ;
 for(i=0;i<n;++i)
  printf("%d:%d\n",i,data[i]) ;

 printf("\n") ;
}


/*search()関数 */
/*データの検索*/
void search(int data[],int n)
{
 int i ;/*繰り返しの制御*/
 int target ;/*検索対象の数値*/

 printf("3:データ検索\n") ;
 printf("検索対象の数値は？\n") ;
 scanf("%d",&target) ;

 for(i=0;i<n;++i)
  if(target==data[i])
   printf("発見　%d:%d\n",i,data[i]) ;

 printf("\n") ;

}


/*cal()関数           */
/*平均・標準偏差の計算*/
void calc(int data[],int n)
{
 int i ;
 double sum=0,average,sigma2=0 ;

 /*平均の計算*/
 for(i=0;i<n;++i)
  sum=sum+data[i] ;
 average=sum/n ;

 /*分散の計算*/
 for(i=0;i<n;++i)
  sigma2
   =sigma2+(data[i]-average)*(data[i]-average) ;
 sigma2=sigma2/n ;/*分散*/

 /*結果の出力*/
 printf("4:平均・標準偏差\n") ;
 printf(" 平均    :%lf\n",average) ;
 printf(" 標準偏差:%lf\n",sqrt(sigma2)) ;
 printf("\n") ;

}


/*graph()関数*/
/*グラフ描画 */
void graph(int data[],int n)
{
 int i,j ;
 int max,min ;/*最大値、最小値*/
 int range ;/*データ値の幅*/

 printf("5:グラフ描画\n") ;
 /*最大・最小を求める*/
 max=min=data[0] ;
 for(i=0;i<n;++i)
  if(data[i]>max) max=data[i] ;
  else if(data[i]<min) min=data[i] ;
 range=max-min ;
 printf("最大値：%d 最小値：%d 幅：%d\n",max,min,range)  ;

 /*グラフの描画*/
 for(i=0;i<n;++i){
  printf("%d(%d)\t",i,data[i]) ;
  for(j=0;j<(data[i]-min)/(double)range*WIDTH;++j)
   printf("*") ;
  printf("\n") ;
 }
 printf("\n") ;
 
}

