/*      ガウスの消去法                          */
/*ガウスの消去法により連立方程式を解くプログラム*/

#include <stdio.h>

#define N 4 /*連立方程式の未知変数の個数*/

/*関数のプロトタイプの宣言*/
void forward(double a[][N+1]) ;/*前進消去*/
void backward(double a[][N+1],double x[N]) ;/*後退代入*/

/*     main()関数    */
int main()
{
 double x[N] ;/*未知変数*/
 int i ;
 int j ;
 double a[N][N+1]/*拡大係数行列*/
  ={{5,4,3,2,35},{1,6,2,3,36},{2,3,7,4,56},
    {3,2,1,8,51}};

 /*前進消去*/
 forward(a) ;
 /* 後退代入*/
 backward(a,x) ;
 /*結果の出力*/
 for(i=0;i<N;++i) 
  printf("%lf\n",x[i]) ;
}

/*     forward(()関数    */
/*       前進消去        */
void forward(double a[][N+1])
{
 double aii,aki ;/*計算に必要な一時変数*/
 int i,j,k ;

 /*前進消去の計算*/
 for(i=0;i<N;++i){
  aii=a[i][i] ;
  for(j=i;j<N+1;++j)
   a[i][j]=a[i][j]/aii ;/*i行の各要素をaiiで割る*/
  for(k=i+1;k<N;++k){/*i+1行以下の計算*/
   aki=a[k][i] ;
   for(j=i;j<N+1;++j)/*項の消去の計算*/
    a[k][j]=a[k][j]-a[i][j]*aki ;
  }
 }
}

/*    backward(()関数    */
/*      後退代入         */
void backward(double a[][N+1],double x[N]) 
{
 double sum ;/*各項の和*/
 int i,j ;

 /*逐次代入を下段から上段へ繰り返す*/
 for(i=N-1;i>=0;--i){
  sum=0 ;
  for(j=i+1;j<N;++j)
   sum+=a[i][j]*x[j] ;/*各項の和*/
  x[i]=a[i][N]-sum ;/*xiの計算*/
 }
}

