# -*- coding: utf-8 -*-
"""
gauss.pyプログラム
ガウスの消去法により連立方程式を解くプログラム
"""

# 大域変数
# 拡大係数行列
a = [[5,4,3,2,35],[1,6,2,3,36],[2,3,7,4,56],[3,2,1,8,51]]
# 未知変数
x = [0, 0, 0, 0]
# 連立方程式の未知変数の個数N
N = 4 

# 下請け関数の定義
# forward()関数
def forward():
    """ 前進消去"""
    for i in range(N):
        aii = a[i][i]
        for j in range(i, N + 1):
            a[i][j] = a[i][j] / aii # i行の各要素をaiiで割る
        for k in range(i + 1, N):   # i + 1行以下の計算
             aki = a[k][i]
             for j in range(i, N + 1):
                 # 項の消去の計算
                 a[k][j] = a[k][j] - a[i][j] * aki
# forward()関数の終わり

# backward()関数
def backward():
    """後退代入"""
    # 逐次代入を下段から上段へ繰り返す
    for i in range(N - 1, -1, -1):
        sum = 0
        for j in range(i + 1, N):
            sum =sum + a[i][j] * x[j] # 各項の和
        x[i] = a[i][N] - sum          # xiの計算
# backward()関数の終わり

# メイン実行部
# 前進消去
forward()

# 後退代入
backward()

# 結果の出力
print(x)
