# -*- coding: utf-8 -*-
"""
integral.pyプログラム
数値積分のプログラム
台形公式を用いて関数f(x)を区間0-1で数値積分します
"""

# 定数
N = 10000 # 区間の分割数

# 下請け関数の定義
# f1()関数
def fx(x):
    """被積分関数"""
    return x * x
# fx()関数の終わり

# メイン実行部
# 変数の初期化
integral = fx(0.0)/2.0  # f(x0)

# 積分値の計算
for i in range (1,N):# 中間部の和
    integral = integral + fx(i / N) 
integral = integral + fx(1.0)/2.0  # f(xn)
integral = integral / N  # h倍

# 結果の出力
print(integral)
