package beans;
import java.io.*;
import java.lang.reflect.*;

public class Info {
    public static Object propValue(Object obj, String propName)
        throws Exception {
        String first = propName.substring(0, 1).toUpperCase();
        String remainder = propName.substring(1);
        String methodName = "get" + first + remainder;
        Class cls = obj.getClass();
        Method method = cls.getMethod(methodName, null);
        return method.invoke(obj, null);
    }

    public static void main (String[] args) {
        try {
            FileInputStream fis = new FileInputStream("Bean.tmp");
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object what = ois.readObject();

            Class cls = what.getClass();
            System.out.println("class = " + cls.getName());
            Field[] fields = cls.getDeclaredFields();
            for (int i = 0; i < fields.length; i++) {
                String name = fields[i].getName();
                Class type = fields[i].getType();
                String typeName = type.getName();
                System.out.println("field [" + i + "] : " + typeName +
                    " " + name + " = " + propValue(what, name));
            }
        } catch (Exception e) { System.err.println(e); }
    } 
}
