package gui;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;

public class Widgets extends JFrame {
    String fruit[] = {"Orange", "Apple", "Banana", "Grape"};
    
    public Widgets() {
	createComponents();

	Container contentPane = getContentPane();
        contentPane.setLayout(new GridLayout (3, 4, 5, 5));
        contentPane.add (jButton);
        contentPane.add (jCheckBox);
        contentPane.add (jRadioButton);
        contentPane.add (jToggleButton);
        contentPane.add (jComboBox);
        contentPane.add (jList);
        contentPane.add (jSlider);
        contentPane.add (jProgressBar);
        contentPane.add (jLabel);
        contentPane.add (jTextField);
        contentPane.add (jPasswordField);
        contentPane.add (jTextArea);

        setTitle ("GUIコンポーネント");
	setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        pack();
	setVisible(true);
    }

    void createComponents() {
        jButton = new JButton ("ボタン");
        jButton.setBorder(new TitledBorder("JButton"));

        jCheckBox = new JCheckBox ("チェックボックス", true);
        jCheckBox.setBorder(new TitledBorder("JCheckBox"));
	jCheckBox.setBorderPainted(true);

        jRadioButton = new JRadioButton ("ラジオボタン", true);
        jRadioButton.setBorder(new TitledBorder("JRadioButton"));
	jRadioButton.setBorderPainted(true);
        
	jToggleButton = new JToggleButton ("トグルボタン");
        jToggleButton.setBorder(new TitledBorder("JToggleButton"));

        jComboBox = new JComboBox (fruit);
        jComboBox.setBorder(new TitledBorder("JComboBox"));
        
        jList = new JList (fruit);
        jList.setBorder(new TitledBorder("JList"));

        jSlider = new JSlider (0, 50, 30);
        jSlider.setMajorTickSpacing(10);
        jSlider.setPaintTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setBorder(new TitledBorder("JSlider"));

        jProgressBar = new JProgressBar (0, 100);
        jProgressBar.setValue(60);
        jProgressBar.setBorder(new TitledBorder("JProgressBar"));

        jLabel = new JLabel ("ラベル");
        jLabel.setBorder(new TitledBorder("JLabel"));

        jTextField = new JTextField ("テキストフィールド");
        jTextField.setBorder(new TitledBorder("JTextField"));

        jPasswordField = new JPasswordField ("パスワードフィールド");
        jPasswordField.setBorder(new TitledBorder("JPasswordField"));

        jTextArea = new JTextArea (
            "テキストエリア...\nテキストエリア...\n");
        jTextArea.setBorder(new TitledBorder("JTextArea"));
    }

    public static void main (String[] args) {
        new Widgets();
    }

    JButton jButton;
    JCheckBox jCheckBox;
    JRadioButton jRadioButton;
    JToggleButton jToggleButton;
    JComboBox jComboBox;
    JList jList;
    JSlider jSlider;
    JProgressBar jProgressBar;
    JLabel jLabel;
    JTextField jTextField;
    JPasswordField jPasswordField;
    JTextArea jTextArea;
}
