package basic;
import javax.servlet.http.*;
import java.io.*;

public class AccessCounter extends HttpServlet {
    private String fileName = "/tmp/accessCounter";
    private Counter counter;
    private Storage storage;

    public void init() {
        storage = new Storage(fileName);
        try {
            counter = (Counter) storage.read();
        } catch (Exception e) {}

        if (counter == null) {  
            // カウンタは保存されていないので, 新規作成
            counter = new Counter();
        }
        storage.keep(counter);
        storage.start();
    }

    public void doGet(HttpServletRequest request, 
        HttpServletResponse response) throws IOException {
        PrintWriter out = response.getWriter();
        int count = counter.getCounter();
        out.println(count);
    }
    
    public void doPost(HttpServletRequest request, 
        HttpServletResponse response) throws IOException {
        doGet(request, response);
    }

    // サーブレットが消滅する前にカウンタを保存する
    public void destroy() { 
        if (storage != null && storage.isAlive()) {
            storage.askStop();
        }
        try {
            storage.write();
        } catch (Exception e) {}
        super.destroy();
    }
}
