package chat;
import net.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;

public class Chat extends HttpServlet {
    private Shared shared = new Shared();

    private class Shared {
        Vector talks = new Vector();
        Hashtable users = new Hashtable();
    }

    private class User {
        String name;      // ユーザ名
        int msgSent;      // msgSent番目のメッセージから送信する
        User(String name, int msgSent) {
            this.name = new String(name);
            this.msgSent = msgSent;
        }
    }

    public void doPost(HttpServletRequest request, 
        HttpServletResponse response) throws IOException {
        ObjectInputStream in = new ObjectInputStream(
            request.getInputStream());
        ChatData data;
        try { 
            data = (ChatData) in.readObject();
        } catch (Exception e) { System.err.println(e); return; }

        if (data.type == ChatData.Enter) {
            String name = data.name;
            HttpSession session = request.getSession(true);
            String sessionId = session.getId();
            data = new ChatData(ChatData.SessionId, 
                null, sessionId, null, null);
            sendToApplet(data, response);
            synchronized (shared) {
                int talksSize = shared.talks.size();
                shared.users.put(sessionId, new User(name, talksSize));
                shared.talks.add(name + "さんが入室しました！");
            }

        } else if (data.type == ChatData.Inquire) {
            String sessionId = data.sessionId;
            Vector msgs;
            synchronized (shared) {
                User user = (User) shared.users.get(sessionId);
                if (user == null) return;
                int msgSent = user.msgSent;
                msgs = new Vector();
                for (int i = msgSent; i < shared.talks.size(); i++) {
                    msgs.add(shared.talks.get(i));
                }
                user.msgSent = shared.talks.size();
            }
            data = new ChatData(ChatData.Msgs, null, null, msgs, null);
            sendToApplet(data, response);

        } else if (data.type == ChatData.Talk) {
            sendToApplet(new ChatData(), response);
            String sessionId = data.sessionId;
            String talk = data.talk;
            synchronized (shared) {
                User user = (User) shared.users.get(sessionId);
                if (user == null) return;
                shared.talks.add(user.name + "さん: " + talk);
            }

        } else if (data.type == ChatData.Exit) {
            sendToApplet(new ChatData(), response);
            String sessionId = data.sessionId;
            synchronized (shared) {
                User user = (User) shared.users.get(sessionId);
                if (user == null) return;
                shared.talks.add(user.name + "さんが退室しました！");
                shared.users.remove(sessionId);
            }
            HttpSession session = request.getSession(false);
            if (session != null) session.invalidate();
        }  
    }

    private void sendToApplet(ChatData data, HttpServletResponse 
        response) throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(
            response.getOutputStream());
        out.writeObject(data);
        out.flush();
    }
}
