<%@ page contentType="text/html; charset=utf-8" %>
<%@ page import="java.util.*,java.text.*" %>

<%
String sessionId = request.getParameter("sessionId");
if (session.isNew() || sessionId == null | 
    !sessionId.equals(session.getId())) {
    // 直接,このorderページに来た
    String toEntryUrl = "/sp/shop/toEntry.jsp";
    response.sendRedirect(toEntryUrl);
    return;
}
synchronized (session) {
    Cart cart = (Cart) session.getAttribute("cart");
    String id = request.getParameter("id");
    if (id != null) {
        String numStr = request.getParameter("num");
        if (numStr == null) {  // ShopページからこのOrderページに来た
            cart.addOrder(id);
        } else {          // Orderページから再びこのOrderページに来た
            int num;
            try {
                num = Integer.parseInt(numStr);
            } catch (NumberFormatException e) {
                num = 1;
            }
            cart.setOrder(id, num);
        }
    }
    String shopUrl = "/sp/servlet/shop.Shop";
    shopUrl = response.encodeURL(shopUrl);
    String orderUrl = "/sp/shop/order.jsp";
    orderUrl = response.encodeURL(orderUrl);
    String checkUrl = "/sp/shop/check.jsp";
    checkUrl = response.encodeURL(checkUrl);
    NumberFormat fmt = NumberFormat.getCurrencyInstance();
%>
<html><head><title>注文 一覧</title></head><body>
<%
    Vector order = cart.getOrder();
    if (order.size() == 0) {  // すべての品の個数を0に指定した場合
%>
        <h2>注文していません</h2>
        <form action="<%= shopUrl %>">
        <input type="hidden" name="sessionId" value="<%= sessionId %>">
        <input type="submit" value="買物を続ける"></form>
<%
    } else {
%>
        <table border="1">
        <tr><th>品名</th><th>価格</th><th>個数</th><th>金額</th></tr>
<%
        Iterator it = order.iterator();
        while (it.hasNext()) {
            OrderedItem oItem = (OrderedItem) it.next();
%>
            <tr><td><%= oItem.getName() %></td>
            <td><%= fmt.format(oItem.getPrice()) %></td>
            <td><form action="<%= orderUrl %>">
            <input type="hidden" name="sessionId" 
                value="<%= sessionId %>">
            <input type="hidden" name="id" 
                value="<%= oItem.getId() %>">
            <input type="text" size="3" name="num" 
                value="<%= oItem.getNum() %>">
            <input type="submit" value="変更"></form></td>
            <td><%= fmt.format(oItem.getTotal()) %></td></tr>
<%
        }
%>
        </table><form action="<%= shopUrl %>">
        <input type="hidden" name="sessionId" value="<%= sessionId %>">
        <input type="submit" value="買物を続ける"></form>
        <form action="<%= checkUrl %>">
        <input type="hidden" name="sessionId" value="<%= sessionId %>">
        <input type="submit" value="   支払い   "></form>
<%
    }
}
%>
</body></html>
