package advanced;
import java.util.*;

public class EventSource implements Runnable {
    public void run() {
        sendEvent();
        try {
            Thread.sleep(1000);              // 1000ms
        } catch (InterruptedException e) {}
        sendEvent();
    }

    private Vector listeners = new Vector();
    public void addWakeUpListener(WakeUpListener lis) {
        listeners.add(lis);
    }

    private void sendEvent() {
        WakeUpEvent ev = new WakeUpEvent(this, new Date());
        Vector copyOfListeners = (Vector) listeners.clone();
        Iterator it = copyOfListeners.iterator();
        while (it.hasNext()) {
            WakeUpListener lis = (WakeUpListener) it.next();
            lis.wakeUp(ev);
        }
    }
}


