package application;
import resource.*;

/**
 * ガソリンスタンドの役割を果します。
 */
public class GasStation extends Tank {
    /**
     * ガソリンスタンドを生成します。
     * @param capacity タンクの容量と残油量
     */
    public GasStation(int capacity) {
        super(capacity, capacity);
    }

    /**
     * タンクを満タンにします。
     * @param tank タンク
     */
    public void fillUp(Tank tank) {
        int amount = tank.fillUp();
        int remain = getFuel() - amount;
        setFuel(remain);
        System.out.println(tank + ": 給油量 = " + amount);
        System.out.println(this + ": 残油量 = " + remain);
    }
}
