package basic;

class Barrier {
    int numThreads = 0;
    int waitThreads = 0;

    synchronized void syncAll() {
        waitThreads++;
        if (waitThreads == numThreads) {
            waitThreads = 0;
            notifyAll();
        } else {
            try {
                wait();
            } catch (InterruptedException e) {}
        }
    }

    public static void main (String args[]) {
        Barrier barrier = new Barrier();
        Thread pn0 = new Thread(new PrintNumber(barrier, 0));
        Thread pn1 = new Thread(new PrintNumber(barrier, 1));
        Thread pn2 = new Thread(new PrintNumber(barrier, 2));
        pn0.start();
        pn1.start();
        pn2.start();
    }
}
