package basic;
import java.io.*;
import java.util.*;

public class Calculate {
    BufferedReader br = new BufferedReader(
        new InputStreamReader(System.in));
    Stack operator = new Stack();
    Stack value = new Stack();

    Calculate() throws IOException {
        String line;

        while ((line = br.readLine()) != null) {
            try {
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.equals("+") || token.equals("-")) {
                        while (!operator.empty()) {
                            popOperator();
                        }
                        operator.push(token);
                    } else {
                        value.push(new Integer(token));
                    }
                }
                while (!operator.empty()) {
                    popOperator();
                }
                Integer answer = (Integer) value.pop();
                if (!value.empty()) {
                    System.err.println("数値オペランドが多過ぎます！");
                    value.clear();
                    continue;
                }
                System.out.println(" = " + answer);
            } catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    void popOperator() {
        String op = (String) operator.pop();
        Integer y = (Integer) value.pop();
        Integer x = (Integer) value.pop();
        if (op.equals("+")) {
            value.push(new Integer(x.intValue() + y.intValue()));
        } else if (op.equals("-")) {
            value.push(new Integer(x.intValue() - y.intValue()));
        }
    }

    public static void main (String[] args) throws IOException {
        System.err.println("数式を入力してください.");
        new Calculate();
    }
}
