package beans;
import java.io.*;

public class Bean implements Serializable {
    private String name;
    private int age;

    public void setName(String name) {
        this.name = name;
    }
    public String getName() {
        return name;
    }
    public void setAge(int age) {
        this.age = age;
    }
    public int getAge() {
        return age;
    }

    public static void main (String[] args) {
        Bean bean1 = new Bean();
        bean1.setName("下村");
        bean1.setAge(20);

        try {
            FileOutputStream fos = new FileOutputStream("Bean.tmp");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(bean1);
            oos.flush();

            FileInputStream fis = new FileInputStream("Bean.tmp");
            ObjectInputStream ois = new ObjectInputStream(fis);
            Bean bean2 = (Bean) ois.readObject();

            System.out.println("bean1: name = " + bean1.getName());
            System.out.println("bean1: age = " + bean1.getAge());
            System.out.println("bean2: name = " + bean2.getName());
            System.out.println("bean2: age = " + bean2.getAge());
        } catch(Exception e) { System.err.println(e); }
    }
}
