package gui;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class AnimationPanel extends JPanel implements ActionListener {
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Image image[] = new Image[3];
    int index = 0;
    // 500ms毎にactionPerformed()を呼出す
    Timer timer = new Timer(500, this);  

    public AnimationPanel() {
        for (int i = 0; i < 3; i++) {
            image[i] = toolkit.createImage("dog" + i + ".gif");
        }
        timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        index = (index + 1) % 3;
        repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int x = getWidth() / 2;
        int y = getHeight() / 2;
        g.drawImage(image[index], x, y, this);
    }

    public static void main (String[] args) {
        JFrame jFrame = new JFrame("アニメーション");
        AnimationPanel animationPanel = new AnimationPanel();
        jFrame.getContentPane().add(
            animationPanel, BorderLayout.CENTER);
        jFrame.setSize(400, 200);
        jFrame.setVisible(true);
    }
}



