package gui;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;

public class Layout extends JFrame {
    public Layout() {
        createComponents (); 
        
	Container contentPane = getContentPane ();
        contentPane.setLayout (new GridLayout (2, 2));
        contentPane.add (jPanel1);
        contentPane.add (jPanel2);
        contentPane.add (jPanel3);
        contentPane.add (jPanel4);

        setTitle ("レイアウト");
	setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        pack ();
	setVisible(true);
    }

    void createComponents () {
	// FlowLayout
        jButton1 = new JButton ("Left");
        jButton2 = new JButton ("to");
        jButton3 = new JButton ("Right");
	jPanel1 = new JPanel (new FlowLayout());
        jPanel1.setBorder(new TitledBorder("FlowLayout"));
	jPanel1.add (jButton1);
	jPanel1.add (jButton2);
	jPanel1.add (jButton3);

	// BorderLayout
        jButton4 = new JButton ("NORTH");
        jButton5 = new JButton ("WEST");
        jButton6 = new JButton ("CENTER");
        jButton7 = new JButton ("EAST");
        jButton8 = new JButton ("SOUTH");
        jPanel2 = new JPanel (new BorderLayout ());
        jPanel2.setBorder(new TitledBorder("BorderLayout"));
	jPanel2.add (jButton4, BorderLayout.NORTH);
	jPanel2.add (jButton5, BorderLayout.WEST);
	jPanel2.add (jButton6, BorderLayout.CENTER);
	jPanel2.add (jButton7, BorderLayout.EAST);
	jPanel2.add (jButton8, BorderLayout.SOUTH);

	// BoxLayout
        jButton9 = new JButton ("Top");
        jButton10 = new JButton ("to");
        jButton11 = new JButton ("Bottom");
        jPanel3 = new JPanel ();
	jPanel3.setLayout(new BoxLayout (jPanel3, BoxLayout.Y_AXIS));
        jPanel3.setBorder(new TitledBorder("BoxLayout"));
	jPanel3.add (jButton9);
	jPanel3.add (jButton10);
	jPanel3.add (jButton11);

	// GridBagLayout
        jButton12 = new JButton ("水平に最大");
        jButton13 = new JButton ("水平に最大に表示");
        jButton14 = new JButton ("水平、垂直");
        jButton15 = new JButton ("水平、垂直に最大");

        jPanel4 = new JPanel (new GridBagLayout ());
        GridBagConstraints c = new GridBagConstraints ();
        jPanel4.setBorder(new TitledBorder("GridBagLayout"));

	c.gridx = 0;  c.gridy = 0;
	c.weightx = 1.0;
	c.fill = GridBagConstraints.HORIZONTAL;
	jPanel4.add (jButton12, c);
    
	c.gridx = 1;  c.gridy = 0;
	jPanel4.add (jButton13, c);
  
	c.gridx = 0;  c.gridy = 1;
	c.weighty = 1.0;
	c.fill = GridBagConstraints.BOTH;
	jPanel4.add (jButton14, c);
  
	c.gridx = 0;  c.gridy = 2;
	c.gridwidth = 2;
	jPanel4.add (jButton15, c);
    }

    public static void main (String[] args) {
        new Layout ();
    }

    JPanel jPanel1, jPanel2, jPanel3, jPanel4;
    JButton jButton1,  jButton2,  jButton3,  jButton4,  jButton5, 
            jButton6,  jButton7,  jButton8,  jButton9,  jButton10,
            jButton11, jButton12, jButton13, jButton14, jButton15;
}
