package net;
import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class ChatApplet extends JApplet implements Runnable {
    private final String servlet = "/sp/servlet/chat.Chat";
    private String protocol, host;
    private int port;
    private String sessionId;

    private String name;
    private JPanel namePanel;
    private JTextField nameTField;
    private JButton enterButton, exitButton;
    private JLabel nameLabel;
    private ChatPanel chatPanel;
    private JLabel msgLabel;
    private Thread thread = null;
    private boolean joinChat = false;
    private boolean running = false;

    public void init() {
        URL url = getCodeBase();      // このアプレットのURL
        protocol = url.getProtocol(); // http
        host = url.getHost();
        port = url.getPort();

        createComponents();

        Container contentPane = getContentPane();
        contentPane.add (namePanel, BorderLayout.NORTH);
        contentPane.add (chatPanel, BorderLayout.CENTER);
        contentPane.add (msgLabel, BorderLayout.SOUTH);
    }

    private void createComponents() {
        JLabel nameLabel = new JLabel("名前：");
        nameTField = new JTextField(10);
        JLabel dummyLabel = new JLabel("    ");
        enterButton = new JButton("入室");
        enterButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) { enter(); }
        });
        exitButton = new JButton("退室");
        exitButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) { exit(); }
        });
        namePanel = new JPanel();
        namePanel.add(nameLabel);
        namePanel.add(nameTField);
        namePanel.add(enterButton);
        namePanel.add(exitButton);

        chatPanel = new ChatPanel() { 
            public void sendMessage(String line) { talk(line); }
        };

        msgLabel = new JLabel("ようこそチャットへ");
        msgLabel.setBorder(new EtchedBorder());
    }

    public void start() {  // アプレットが現れた時
        if (joinChat) {
            running = true;
            if ((thread == null) || !thread.isAlive()) {
                thread = new Thread(this);
                thread.start();
            }
        }
    }

    public void stop() {  // アプレットが隠れた時
	running = false;
    }

    private void enter() {
        if (joinChat) return;
        joinChat = true;
        name = nameTField.getText().trim();
        try {
            ChatData data = new ChatData(ChatData.Enter, 
                name, null, null, null);
            data = communicate(servlet, data, null);
            sessionId = data.sessionId;
            start();
        } catch (Exception e) { msgLabel.setText(e.toString()); }
        msgLabel.setText("チャットに参加しました");
    }

    public void run() {  // スレッドが走る
        while (running) {
            msgLabel.setText("チャット中です...");  
            try {
                ChatData data = new ChatData(ChatData.Inquire, 
                    null, sessionId, null, null);
                data = communicate(servlet, data, null);
                Iterator it = data.msgs.iterator();
                while (it.hasNext()) {
                    chatPanel.recvMessage((String) it.next());
                }
                Thread.sleep(1000);
            } catch (Exception e) { msgLabel.setText(e.toString()); }
        }
    }

    private void talk(String talk) {
        if (!joinChat) return;
        try {
            ChatData data = new ChatData(ChatData.Talk, 
                null, sessionId, null, talk);
            communicate(servlet, data, null);
        } catch (Exception e) { msgLabel.setText(e.toString()); }
        msgLabel.setText("発言内容を送信しました"); 
    }

    private void exit() {
        if (!joinChat) return;
        joinChat = false;
        try {
            stop();
            thread.join();
            ChatData data = new ChatData(ChatData.Exit, 
                null, sessionId, null, null);
            communicate(servlet, data, sessionId);
        } catch (Exception e) { msgLabel.setText(e.toString()); }
        msgLabel.setText("チャットから退出しました");
    }

    private synchronized ChatData communicate(String sessionUrl, 
        ChatData data, String sessionId) throws Exception {
        URL servletUrl = new URL(protocol, host, port, sessionUrl);
        URLConnection con = servletUrl.openConnection();
        if (sessionId != null) 
            con.setRequestProperty("Cookie", 
                "JSESSIONID=" + sessionId);
        con.setUseCaches(false);
        con.setDoOutput(true);
        ObjectOutputStream out = new ObjectOutputStream(
            con.getOutputStream());
        out.writeObject(data);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(
            con.getInputStream());
        ChatData readData = (ChatData) in.readObject();
        return readData;
    }
}
