<%@ page contentType="text/html; charset=utf-8" %>
<%@ page import="java.util.*,java.text.*" %>

<%
String sessionId = request.getParameter("sessionId");
if (session.isNew() || sessionId == null | 
    !sessionId.equals(session.getId())) {
    // 直接,このcheckページに来た
    String toEntryUrl = "/sp/shop/toEntry.jsp";
    response.sendRedirect(toEntryUrl);
    return;
}
response.setHeader("content-style-type", "text/css");
synchronized (session) {
    Cart cart = (Cart) session.getAttribute("cart");
    String name = (String) session.getAttribute("name");
%>
<html><head><title>お買上げ</title></head><body>
<%
    Vector order = cart.getOrder();
    if (order.size() == 0) {
%>
        <h2>注文していません</h2>
<%
    } else {
%>
        <h2><%= name %>様：お買上げありがとうございます</h2>
        <table border="1">
        <tr><th>品名</th><th>価格</th><th>個数</th><th>金額</th></tr>
<%
        NumberFormat fmt = NumberFormat.getCurrencyInstance();
        int total = 0;
        Iterator it = order.iterator();
        while (it.hasNext()) {
            OrderedItem oItem = (OrderedItem) it.next();
            int subtotal = oItem.getTotal();
            total += subtotal;
%>
            <tr><td><%= oItem.getName() %></td>
            <td><%= fmt.format(oItem.getPrice()) %></td>
            <td><%= oItem.getNum() %></td>
            <td><%= fmt.format(subtotal) %></td></tr>
<%
        }
%>
        </table><p>お買上げの合計金額は<span style="font-weight:bold">
        <%= fmt.format(total) %></span>です</p>
<%
    }
%>
    </body></html>
<%
    session.invalidate();
}
%>
