import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class AnimationApplet extends JApplet 
    implements ActionListener {
    JButton startButton, stopButton;
    Image image[];
    int index = 0;
    int frames;
    Timer timer = new Timer(500, this);

    public void init() {
        String imageFileName = getParameter("image");
        frames = Integer.parseInt(getParameter("frames"));
        image = new Image[frames];
        for (int i = 0; i < frames; i++) {
            image[i] = getImage(getCodeBase(), 
                imageFileName + i + ".gif");
        }

        JPanel imagePanel = new JPanel() {
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.drawString("こんにちは！", 10, 20);
                g.drawImage(image[index], 
                    getWidth() / 2, getHeight() / 2, this);
            }
        };

        JPanel buttonPanel = new JPanel();
        startButton = new JButton("開始");
        stopButton = new JButton("終了");
        startButton.addActionListener(this);
        stopButton.addActionListener(this);
        buttonPanel.add(startButton);
        buttonPanel.add(stopButton);

        Container contentPane = getContentPane();
        contentPane.add (imagePanel, BorderLayout.CENTER);
        contentPane.add (buttonPanel, BorderLayout.SOUTH);
    }

    public void actionPerformed (ActionEvent ev) {
        if (ev.getSource() == timer) {
            index = (index + 1) % frames;
            repaint();
        } else if (ev.getSource() == startButton) {
            timer.start();
        } else if (ev.getSource() == stopButton) {
            timer.stop();
        } 
    }

    public void start() {
        timer.start();
    }

    public void stop() {
        timer.stop();
    }
}
