package beans;
import java.io.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class Clock extends JFrame 
    implements ActionListener , Runnable {
    private JLabel clock;
    private JButton saveButton, restoreButton, restartButton;
    private transient Thread thread;
    private static Clock restoredClock = null;
    
    public Clock() {
        Container contentPane = getContentPane();
        contentPane.setLayout (new GridBagLayout ());
        GridBagConstraints c = new GridBagConstraints ();

        clock = new JLabel ("HH  mm  ss  ", SwingConstants.CENTER);
        c.weightx = 1.0;
        c.fill = GridBagConstraints.HORIZONTAL;
        contentPane.add (clock, c);

        saveButton = new JButton ("保存");
        saveButton.addActionListener (this);
        c.gridy = 1;  c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        contentPane.add (saveButton, c);

        restoreButton = new JButton ("復元");
        restoreButton.addActionListener (this);
        c.gridy = 2;
        contentPane.add (restoreButton, c);

        restartButton = new JButton ("再開");
        restartButton.addActionListener (this);
        c.gridy = 3;
        contentPane.add (restartButton, c);

        setTitle("時計の保存、復元、再開");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(250, 150);
        setLocation(100, 200);
        setVisible(true);
        thread = new Thread(this);
        thread.start();
    }

    public void actionPerformed (ActionEvent ev) {
        if (ev.getSource() == saveButton) {
            try {
                FileOutputStream fos = new FileOutputStream(
                    "Clock.tmp");
                ObjectOutputStream oos = new ObjectOutputStream(fos);
                oos.writeObject(this);
                oos.flush();
            } catch(Exception e) { System.err.println(e); }

        } else if (ev.getSource() == restoreButton) {
            try {
                FileInputStream fis = new FileInputStream("Clock.tmp");
                ObjectInputStream ois = new ObjectInputStream(fis);
                if (restoredClock != null) {
                    restoredClock.setVisible(false);
                }
                restoredClock = (Clock) ois.readObject();
                restoredClock.setVisible(true);
                restoredClock.repaint();
            } catch(Exception e) { System.err.println(e); }

        } else if (ev.getSource() == restartButton) {
            thread = new Thread(this);
            thread.start();
        } 
    }

    public void run() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(
                "HH時mm分ss秒");
            while (true) {
                Thread.sleep(1000);
                clock.setText(sdf.format(new Date()));
            }
        } catch (Exception e) { System.err.println(e); }
    }

    public static void main (String[] args) {
        new Clock ();
    }
}






