package gui;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class ImagePanel extends JPanel {
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Image image[] = new Image[3];
    int index = 0;
    int x = 50, y = 50;

    public ImagePanel() {
        for (int i = 0; i < 3; i++) {
            image[i] = toolkit.createImage("dog" + i + ".gif");
        }
        addMouseMotionListener(new MouseMotionAdapter() {
            public void mouseDragged(MouseEvent e) {
		x = e.getX();
		y = e.getY();
		index = (index + 1) % 3;
		repaint();
	    }
        }
        );
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(image[index], x, y, this);
    }

    public static void main (String[] args) {
        JFrame jFrame = new JFrame("画像をドラッグ");
        ImagePanel imagePanel = new ImagePanel();
        jFrame.getContentPane().add(imagePanel, BorderLayout.CENTER);
        jFrame.setSize(400, 200);
        jFrame.setVisible(true);
    }
}
