package gui;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class MyDialog extends JFrame {
    public MyDialog() {
        createComponents ();

        Container contentPane = getContentPane ();
        contentPane.setLayout (new GridBagLayout ());
        GridBagConstraints c = new GridBagConstraints ();

        c.gridx = 0;  c.gridy = 0;
        c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        contentPane.add (jButton0, c);

        c.gridx = 0;  c.gridy = 1;
        contentPane.add (jButton1, c);

        c.gridx = 0;  c.gridy = 2;
        contentPane.add (jButton2, c);

        c.gridx = 0;  c.gridy = 3;
        contentPane.add (jButton3, c);

        c.gridx = 0;  c.gridy = 4;
        contentPane.add (jButton4, c);

        c.gridx = 0;  c.gridy = 5;
        contentPane.add (jButton5, c);

        c.gridx = 1;  c.gridy = 1;
        c.weightx = 1.0;  c.weighty = 1.0;
        contentPane.add (jLabel1, c);

        c.gridx = 1;  c.gridy = 2;
        contentPane.add (jLabel2, c);

        c.gridx = 1;  c.gridy = 3;
        contentPane.add (jLabel3, c);

        c.gridy = 4;  c.weightx = 1.0;
        contentPane.add (jLabel4, c);

        c.gridx = 1;  c.gridy = 5;
        contentPane.add (jLabel5, c);

        setTitle ("いろいろなダイアログ");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(420, 200);
        setVisible(true);
    }

    private void createComponents () {
        jButton0 = new JButton ("メッセージダイアログ");
        jButton1 = new JButton ("確認ダイアログ");
        jLabel1 = new JLabel ("確認は？");
        jButton2 = new JButton ("入力ダイアログ");
        jLabel2 = new JLabel ("入力テキストは？");
        jButton3 = new JButton ("色選択ダイアログ");
        jLabel3 = new JLabel ("色名は？");
        jButton4 = new JButton ("ファイルを開く");
        jLabel4 = new JLabel ("ファイル名は？");
        jButton5 = new JButton ("ファイルを保存");
        jLabel5 = new JLabel ("ファイル名は？");

        jButton0.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev) {
                jButton0ActionPerformed (ev);
            }
        }
        );
        jButton1.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev) {
                jButton1ActionPerformed (ev);
            }
        }
        );
        jButton2.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev) {
                jButton2ActionPerformed (ev);
            }
        }
        );
        jButton3.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev) {
                jButton3ActionPerformed (ev);
            }
        }
        );
        jButton4.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev) {
                jButton4ActionPerformed (ev);
            }
        }
        );
        jButton5.addActionListener (new ActionListener () {
            public void actionPerformed (ActionEvent ev) {
                jButton5ActionPerformed (ev);
            }
        }
        );
    }

    private void jButton0ActionPerformed (ActionEvent ev) {
        JOptionPane.showMessageDialog(jButton0, 
            "メッセージダイアログです", 
	    "JOptionPane.showMessageDialog", 
            JOptionPane.INFORMATION_MESSAGE);
    }

    private void jButton1ActionPerformed (ActionEvent ev) {
	int result = JOptionPane.showConfirmDialog(
            this, "確認してください", "JOptionPane.showConfirmDialog",
            JOptionPane.YES_NO_CANCEL_OPTION, 
            JOptionPane.QUESTION_MESSAGE);
        if (result == JOptionPane.YES_OPTION) {
	    jLabel1.setText("はい");
        } else if (result == JOptionPane.NO_OPTION) {
	    jLabel1.setText("いいえ");        
        } else if (result == JOptionPane.CANCEL_OPTION) {
	    jLabel1.setText("取消し");        
        }
    }

    private void jButton2ActionPerformed (ActionEvent ev) {
        String text = JOptionPane.showInputDialog(
            this, "入力してください", "JOptionPane.showInputDialog", 
            JOptionPane.QUESTION_MESSAGE);
        if (text != null) {
	    jLabel2.setText(text);
        }    
    }

    private void jButton3ActionPerformed (ActionEvent ev) {
	Color color = JColorChooser.showDialog(
            this, "色選択ダイアログ", new Color(0, 0, 0));
        if (color != null) {
	    jLabel3.setForeground(color);
	    jLabel3.setText(color.toString());
        }
    }

    private void jButton4ActionPerformed (ActionEvent ev) {
        String currentDirName = System.getProperty("user.dir");
        File currentDir = new File(currentDirName);
        JFileChooser fc = new JFileChooser(currentDir);
        MyFileFilter filter;
        filter = new MyFileFilter(
            new String []{"class"}, "Java Class File");
        fc.addChoosableFileFilter(filter);
        filter = new MyFileFilter(
            new String []{"java"}, "Java Source File");
        fc.addChoosableFileFilter(filter);

        int result = fc.showOpenDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
	    jLabel4.setText(fc.getSelectedFile().getName());
        }    
    }

    private void jButton5ActionPerformed (ActionEvent ev) {
        JFileChooser fc = new JFileChooser();
        int result = fc.showSaveDialog(this);
        if (result == JFileChooser.APPROVE_OPTION) {
	    jLabel5.setText(fc.getSelectedFile().getPath());
        }    
    }

    public static void main (String args[]) {
        new MyDialog ();
    }

    private JButton jButton0, jButton1, jButton2, jButton3, jButton4,
                    jButton5;
    private JLabel jLabel1, jLabel2, jLabel3, jLabel4, jLabel5;
}
