package gui;
import java.io.*;
import javax.swing.filechooser.FileFilter;

public class MyFileFilter extends FileFilter {
    private String filters[] = null;
    private String description = null;
    private String fullDescription = null;   
    
    MyFileFilter(String[] filters, String description) {
        this.filters = filters;
        this.description = description;
    }

    public boolean accept(File f) {
	if(f != null) {
	    if(f.isDirectory()) {
		return true;    // 下のディレクトリ階層を表示
	    }
	    String ext = getExtension(f);
	    if(ext != null) {
                for (int i=0; i<filters.length; i++) {
	            if(ext.compareToIgnoreCase(filters[i]) == 0) {
		        return true;                        
                    }
	        }
	    }
	}
	return false;
    }

    public String getDescription() {
 	fullDescription = description + " (*." + filters[0];
	for (int i=1; i < filters.length; i++) {
	    fullDescription += "; *." + filters[i];
	}
	fullDescription += ")";
	return fullDescription;
    }

    private String getExtension(File f) {
	if(f != null) {
	    String filename = f.getName();
	    int i = filename.lastIndexOf('.');
	    if (0 < i && i < filename.length()-1) {
		return filename.substring(i+1);
	    }
	}
	return null;
    }
}

