package gui;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.geom.Rectangle2D;

public class RotatePanel extends JPanel implements ActionListener {
    Timer timer = new Timer(100, this);
    int times = 0;

    public RotatePanel() {
        timer.start(); 
    }

    public void actionPerformed(ActionEvent e) {
        times = (times + 1) % 60;                 // 0 to 59
        repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D) g;

        g2d.setStroke(new BasicStroke(5.0f)); // 線の幅(float)
        g2d.setPaint(Color.blue);
        g2d.draw(new Polygon(new int[]{0, 0, 40}, 
            new int[]{0, 40, 20}, 3));

        int cx = getWidth() / 2;
        int cy = getHeight() / 2;
        g2d.rotate((2 * Math.PI * times) / 60, cx, cy);

        Font font = new Font("Serif", Font.PLAIN, 20);
        g2d.setFont(font);
        String str = "Graphics2D";
        g2d.drawString(str, cx, cy);

        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D rec = fm.getStringBounds(str, g2d);
        int x = cx + (int) rec.getX();
        int y = cy + (int) rec.getY();
        int w = (int) rec.getWidth();
        int h = (int) rec.getHeight();
        g2d.draw(new Rectangle(x, y, w, h));
    }

    public static void main (String[] args) {
        JFrame jFrame = new JFrame("グラフィックスの回転");
        RotatePanel rotatePanel = new RotatePanel();
        jFrame.getContentPane().add(rotatePanel, BorderLayout.CENTER);
        jFrame.setSize(400, 200);
        jFrame.setVisible(true);
    }
}
