package net;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public abstract class ChatPanel extends JPanel 
    implements ActionListener, AdjustmentListener {
    public ChatPanel() {
        createComponents ();

        setLayout (new GridBagLayout ());
        GridBagConstraints c = new GridBagConstraints ();

        c.gridx = 0;  c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;  c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        add (chatScrollPane, c);

        c.gridx = 0;  c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;  c.weighty = 0.0;
        add (talkTextField, c);

        c.gridx = 1;  c.gridy = 1;
        c.weightx = 0.0;
        add (talkButton, c);
    }

    private void createComponents () {
        chatScrollPane = new JScrollPane ();
        vScroll = chatScrollPane.getVerticalScrollBar();
        vScroll.addAdjustmentListener(this);
        chatTextArea = new JTextArea();
        chatTextArea.setEditable(false);
        chatScrollPane.setViewportView (chatTextArea);

        talkTextField = new JTextField();
        talkButton = new JButton("発言");
        talkButton.addActionListener(this);
    }
    
    public void actionPerformed(ActionEvent e) {
        sendMessage(talkTextField.getText());
        talkTextField.setText("");
    }

    // サブクラスでオーバライドする
    public abstract void sendMessage(String line);
    public void recvMessage(String line) { 
        chatTextArea.append(line + "\n"); 
        changeScroll = true;
    }

    public void adjustmentValueChanged(AdjustmentEvent ev) {
        if (changeScroll) {
            changeScroll = false;
            vScroll.setValue(vScroll.getMaximum());
        }
    }

    private boolean changeScroll = false;
    private JScrollPane chatScrollPane;
    private JScrollBar vScroll;
    private JTextArea chatTextArea;
    private JTextField talkTextField;
    private JButton talkButton;
}




