package net;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;

public class ConnectPanel extends JPanel implements ActionListener {
    public ConnectPanel() {
        createComponents ();

        setLayout (new GridBagLayout ());
        GridBagConstraints c = new GridBagConstraints ();

        c.gridx = 0;  c.gridy = 0;
        c.weightx = 2.0;  c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        add (choicePanel, c);

        c.gridx = 0;  c.gridy = 1;
        add (serverPanel, c);

        c.gridx = 1;  c.gridy = 1;
        c.weightx = 1.0;
        add (portPanel, c);

        c.gridx = 2;  c.gridy = 1;
        c.weightx = 2.0;
        add (userPanel, c);

        c.gridx = 2;  c.gridy = 2;
        add (connectButton, c);
    }

    void createComponents () {
        choicePanel = new JPanel ();
        choicePanel.setLayout(
            new BoxLayout (choicePanel, BoxLayout.Y_AXIS));
        serverButton = new JRadioButton("サーバ");
        clientButton = new JRadioButton("クライアント", true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(serverButton);  bg.add(clientButton); 
        serverButton.addActionListener(this);
        clientButton.addActionListener(this);
        choicePanel.add(serverButton);
        choicePanel.add(clientButton);

        serverPanel = new JPanel ();
        serverPanel.setLayout(
            new BoxLayout (serverPanel, BoxLayout.Y_AXIS));
        serverLabel = new JLabel("サーバ名");
        serverTextField = new JTextField();
        serverPanel.add(serverLabel);
        serverPanel.add(serverTextField);

        portPanel = new JPanel ();
        portPanel.setLayout(
            new BoxLayout (portPanel, BoxLayout.Y_AXIS));
        portLabel = new JLabel("ポート番号");
        portTextField = new JTextField("9999");
        portPanel.add(portLabel);
        portPanel.add(portTextField);

        userPanel = new JPanel ();
        userPanel.setLayout(
            new BoxLayout (userPanel, BoxLayout.Y_AXIS));
        userLabel = new JLabel("ニックネーム");
        userTextField = new JTextField();
        userPanel.add(userLabel);
        userPanel.add(userTextField);

        connectButton = new JButton("接続");
        connectButton.addActionListener(this);
    }

    public void actionPerformed (ActionEvent ev) {
        String localHostName;
        try {
            localHostName = InetAddress.getLocalHost().getHostName();
        } catch (Exception e) { System.err.println(e); return; }

        if (ev.getSource() == serverButton) {
            serverTextField.setText(localHostName);
            userTextField.setText("--------");
            connectButton.setText("起動");

        } else if (ev.getSource() == clientButton) {
            serverTextField.setText("");
            userTextField.setText("");
            connectButton.setText("接続");

        } else if (ev.getSource() == connectButton) {
            Chat.serverName = serverTextField.getText();
            String portNumber = portTextField.getText();
            Chat.userName = userTextField.getText();
            boolean serverSelected = serverButton.isSelected();

            if (serverSelected) {
                if (Chat.connected) return;
                Chat.whichSide = Chat.Side.Server;
                connect(portNumber);
            } else {
                Chat.whichSide = Chat.Side.Client;
                connect(Chat.serverName, portNumber);
            }
        } 
    }

    void connect(String portNumber) {
        try {
            int port = Integer.parseInt(portNumber);
            Chat.serverSocket = new ServerSocket(port);
            connectButton.setText("起動 完了");
            serverButton.setEnabled(false);
            clientButton.setEnabled(false);
            Chat.connected = true;
        } catch (Exception e) { System.err.println(e); }
    }

    static void connect(String serverName, String portNumber) {
        try {
            int port = Integer.parseInt(portNumber);
            Chat.clientSocket = new Socket(serverName, port);
            Chat.connected = true;
        } catch (Exception e) { System.err.println(e); }
    }

    JPanel choicePanel, serverPanel, portPanel, userPanel;
    JRadioButton serverButton, clientButton;
    JLabel serverLabel, portLabel, userLabel;
    JTextField serverTextField, portTextField, userTextField;
    JButton connectButton;
}
