package net;
import java.net.*;
import java.io.*;
import java.util.*;

public class Server extends Thread {
    static Vector users = new Vector();
    Socket s;
    DataInputStream in;
    DataOutputStream out;

    Server(Socket s) {
        this.s = s;
        users.add(this);
    }

    public void run() {
        try {
            in = new DataInputStream(s.getInputStream());
            out = new DataOutputStream(s.getOutputStream());
            while (true) {
                String line = in.readUTF();
                sendToClients(line);
            }
        } catch (Exception e) { 
            System.err.println("クライアントが接続を終了しました");
            users.remove(this);
        }
    }

    void sendToClients(String line) throws Exception {
        Vector usersCopy = (Vector) users.clone();
        Iterator it = usersCopy.iterator();
        while (it.hasNext()) {
            Server server = (Server) it.next();
            server.out.writeUTF(line);
        }
    }
}
