package reserve;
import javax.servlet.http.*;
import java.io.*;
import java.sql.*;

public class Reserve extends HttpServlet {
    private final String dbUrl = "jdbc:postgresql:meeting";
    private final String dbUser = "simomura";
    private final String dbPwd = "";
    private Connection con;
    private final String resultUrl = "/sp/reserve/result.jsp";

    public void init() {
        try {
            Class.forName("org.postgresql.Driver");
            con = DriverManager.getConnection(dbUrl, dbUser, dbPwd);
        } catch (Exception e) { System.err.println(e); }
    }

    public void doGet(HttpServletRequest request, 
        HttpServletResponse response) throws IOException {
        String sessionId = request.getParameter("sessionId");
        if (sessionId != null) {
            Cookie sessionCookie = new Cookie("JSESSIONID", sessionId);
            sessionCookie.setPath("/sp");
            response.addCookie(sessionCookie);
            // ブラウザがクッキーを受け付けない時
            String sessionUrl = resultUrl + ";jsessionid=" + sessionId;  
            response.sendRedirect(sessionUrl);
            return;
        }

        int year = Integer.parseInt(request.getParameter("year"));
        int month = Integer.parseInt(request.getParameter("month"));
        int day = Integer.parseInt(request.getParameter("day"));
        // Reservationオブジェクトを送信
        try {
            sendReservation(year, month, day, response);
        } catch (Exception e) { System.err.println(e); }
    }

    public void doPost(HttpServletRequest request, 
        HttpServletResponse response) throws IOException {
        // Reservationオブジェクトを受信
        try {
            recvReservation(request, response);
        } catch (Exception e) { error(e, response); }
    }

    private void sendReservation(int year, int month, int day, 
        HttpServletResponse response) throws Exception {
        Reservation r = new Reservation();
        int[] hours = r.getHours();
        String[] rooms = r.getRooms();
        Cell[][] cells = r.getCells();
        String table = "y" + String.valueOf(year) + 
            "m" + String.valueOf(month) + "d" + String.valueOf(day);

        // 予約状況をデータベースから検索し、Reservationに設定
        Statement stm = con.createStatement();
        for (int col = 1; col < rooms.length; col++) {
            String room = rooms[col];
            String query = "select hour, name from " + table +
                " where room = '" + room + "'";
            ResultSet result = stm.executeQuery(query);
            while (result.next()) {
                int hour = result.getInt(1);  // 列は1から始まる
                String name = result.getString(2);
                int row = r.hourToRow(hour);
                cells[row][col].name = name;
            }
        }
        sendToApplet(r, response);
    }

    private void recvReservation(HttpServletRequest request, 
        HttpServletResponse response) throws Exception {
        ObjectInputStream objIn = 
            new ObjectInputStream(request.getInputStream());
        Reservation r = (Reservation) objIn.readObject();

        // 予約、キャンセルReservationによりデータベースを更新
        Statement stm = con.createStatement();
        int[] hours = r.getHours();
        String[] rooms = r.getRooms();
        String person = r.getPerson();
        Cell[][] cells = r.getCells();
        int year = r.getYear();
        int month = r.getMonth();
        int day = r.getDay();
        String table = "y" + String.valueOf(year) + 
            "m" + String.valueOf(month) + "d" + String.valueOf(day);

        con.setAutoCommit(false);
        try {
            String cmd = "lock table " + table + 
                " in access exclusive mode";
            stm.execute(cmd);
            for (int row = 0; row < hours.length; row++) {
                int hour = hours[row];
                for (int col = 1; col < rooms.length; col++) {
                    if (!cells[row][col].selected) continue;
                    String room = rooms[col];
                    cmd = "select name from " + table + 
                    " where room = '" + room + "' and hour = " + hour;
                    ResultSet result = stm.executeQuery(cmd);
                    if (cells[row][col].name.equals("")) {  // 予約
                        if (result.next()) {
                            throw new Exception("ダブルブッキング");
                        }
                        cmd = "insert into " + table + " values('" +
                        room + "', " + hour + ", '" + person + "')";

                    } else {                           // キャンセル
                        if (!result.next()) continue;
                        String name = result.getString(1);
                        if (!person.equals(name)) {
                            throw new Exception(
                                "他人の予約はキャンセルできません");
                        }
                        cmd = "delete from " + table + 
                    " where room = '" + room + "' and hour = " + hour;
                    }
                    stm.executeUpdate(cmd);
                }
            }	
            con.commit();
        } catch (Exception e) { con.rollback(); throw e; 
        } finally { con.setAutoCommit(true); }

        HttpSession session = request.getSession(true);
        session.setAttribute("r", r);  // rをresult.jspに渡す
        String sessionId = session.getId();
        Result result = new Result(Result.OK, sessionId, null);
        sendToApplet(result, response);
    }

    private void sendToApplet(Serializable obj, HttpServletResponse 
        response) throws IOException {
        ObjectOutputStream out = 
            new ObjectOutputStream(response.getOutputStream());
        out.writeObject(obj);
        out.flush();
    }

    private void error(Exception e, HttpServletResponse response)
        throws IOException {
        Result result = new Result(Result.NG, null, e);
        sendToApplet(result, response);
    }
}
