package shop;
import java.util.*;

public class Cart {
    private Vector order = new Vector();

    public Vector getOrder() {
        return order;
    }

    public void addOrder(String id) {
        OrderedItem oItem = findOrderedItem(id);
        if (oItem != null) {
            oItem.incNum();
            return;
        }
        oItem = new OrderedItem(DB.getItem(id));
        order.add(oItem);
    }

    public void setOrder(String id, int num) {
        OrderedItem oItem = findOrderedItem(id);
        if (oItem != null) {
            if (num <= 0) {
                order.remove(oItem);
            } else {
                oItem.setNum(num);
            }
            return;
        }
        oItem = new OrderedItem(DB.getItem(id));
        oItem.setNum(num);
        order.add(oItem);
    }

    private OrderedItem findOrderedItem(String id) {
        Iterator it = order.iterator();
        while (it.hasNext()) {
            OrderedItem oItem = (OrderedItem) it.next();
            if (oItem.getId().equals(id)) {
                return oItem;
            }
        }
        return null;
    }
}
