package shop;
import javax.servlet.http.*;
import java.io.*;
import java.text.*;

public class Shop extends HttpServlet {
    private Item[] items;

    public void init() {
        items = new Item[3];
        items[0] = DB.getItem("fruit01");
        items[1] = DB.getItem("fruit02");
        items[2] = DB.getItem("fruit03");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse
        response) throws IOException {
        HttpSession session = request.getSession(false);
	String sessionId = request.getParameter("sessionId");
        if (session == null || sessionId == null | 
            !sessionId.equals(session.getId())) {
            // 直接,このShopサーブレットに来た
            String toEntryUrl = "/sp/shop/toEntry.jsp";
            response.sendRedirect(toEntryUrl);
            return;
        }
        synchronized (session) {
            Cart cart = (Cart) session.getAttribute("cart");
            if (cart == null) {  // 新しい訪問者
                cart = new Cart();
                session.setAttribute("cart", cart);
                String name = request.getParameter("name");
                name = new String(
                    name.getBytes("ISO8859_1"), "UTF-8");
                session.setAttribute("name", name);
            }
        }

        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.println("<html><head><title>ショッピングモール</title>" +
            "</head><body>");
        String orderUrl = "/sp/shop/order.jsp";
        orderUrl = response.encodeURL(orderUrl);
        NumberFormat fmt = NumberFormat.getCurrencyInstance();
        out.println("<table border=\"1\">" + 
            "<tr><th>品名</th><th>価格</th></tr>");
        for (int i = 0; i < items.length; i++) {
            out.println("<tr><td>" + items[i].getName() + "</td>" +
                "<td>" +  fmt.format(items[i].getPrice()) + "</td>" +
		"<td><form action=\"" + orderUrl + "\">" +
                "<input type=\"hidden\" name=\"id\" value=\"" +
                items[i].getId() + "\">" +
                "<input type=\"hidden\" name=\"sessionId\" value=\"" +
                sessionId + "\">" +
                "<input type=\"submit\" value=\"カートに入れる\">" +
                "</form></td></tr>");
        }
        out.println("</table></body></html>");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse
        response) throws IOException {
        doGet(request, response);
    }
}
