package reserve;
import java.io.*;

public class Reservation implements Serializable {
    private int[] hours = new int[] {  // 行
        9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20
    };
    private String[] rooms = new String[] {  // 列
        "時間帯", "会議室 A", "会議室 B", "会議室 C"
    };
    private String person = null;
    private Cell[][] cells = new Cell[hours.length][rooms.length];
    private int year, month, day;

    public Reservation() {
        for (int row = 0; row < hours.length; row++) {
            cells[row][0] = new Cell(false, hours[row] + " 時〜");
            for (int col = 1; col < rooms.length; col++) {
                cells[row][col] = new Cell();
            }
        }
    }

    public String[] getRooms() {
        return rooms;
    }
    public int[] getHours() {
        return hours;
    }
    public void setPerson(String person) {
        this.person = person;
    }
    public String getPerson() {
        return person;
    }
    public Cell[][] getCells() {
        return cells;
    }
    public void setYear(int year) { this.year = year; }
    public int getYear() { return year; }
    public void setMonth(int month) { this.month = month; }
    public int getMonth() { return month; }
    public void setDay(int day) { this.day = day; }
    public int getDay() { return day; }

    public int hourToRow(int hour) throws Exception {
        for (int row = 0; row < hours.length; row++) {
            if (hour == hours[row]) return row;
        }
        throw new Exception("hour " + hour + " が範囲外");
    }
    public int rowToHour(int row) {
        return hours[row];
    }
    public String colToRoom(int col) {
        return rooms[col];
    }
}
