package reserve;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;

public class ReserveApplet extends JApplet {
    private final int cellHeight = 25; 
    private final int cellWidth = 100;
    private final int Row = 0;
    private final int Col = 1;
    private int[] selectedIndex = new int[2];
    private int selectedTimes = 0;

    private String name;
    private int year, month, day;
    private Reservation reservation = null;
    private String [] rooms;
    private int[] hours;
    private Cell[][] cells;
    private TableModel model;
    private JTable table;

    private JScrollPane scrollPane;
    private JPanel reservePanel, controlPanel, namePanel, buttonPanel;
    private JTextField nameTField, yearTField, monthTField, dayTField;
    private JButton displayButton, applyButton, clearButton;
    private JLabel titleLabel, msgLabel;

    private String protocol, host;
    private final String servlet = "/sp/servlet/reserve.Reserve";
    private int port;

    public void init() {
        URL url = getCodeBase();      // このアプレットのURL
        protocol = url.getProtocol(); // http
        host = url.getHost();
        port = url.getPort();

        createComponents();
        Container contentPane = getContentPane();
        contentPane.add (titleLabel, BorderLayout.NORTH);
        contentPane.add (scrollPane, BorderLayout.CENTER);
        contentPane.add (controlPanel, BorderLayout.SOUTH);
    }

    private void createComponents() {
        titleLabel = new JLabel("予約状況： ");
        scrollPane = new JScrollPane();

        JLabel nameLabel = new JLabel("名前：");
        nameTField = new JTextField(10);
        JLabel dateLabel = new JLabel("  予約日：");
        yearTField = new JTextField(4);
        JLabel yearLabel = new JLabel("年");
        monthTField = new JTextField(2);
        JLabel monthLabel = new JLabel("月");
        dayTField = new JTextField(2);
        JLabel dayLabel = new JLabel("日");
        namePanel = new JPanel();
        namePanel.add(nameLabel);
        namePanel.add(nameTField);
        namePanel.add(dateLabel);
        namePanel.add(yearTField);
        namePanel.add(yearLabel);
        namePanel.add(monthTField);
        namePanel.add(monthLabel);
        namePanel.add(dayTField);
        namePanel.add(dayLabel);

        displayButton = new JButton("予約状況の表示");
        displayButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) { display(); }
        });
        applyButton = new JButton("  申し込む  ");
        applyButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) { apply(); }
        });
        clearButton = new JButton("  取消し  ");
        clearButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) { clear(); }
        });
        buttonPanel = new JPanel();
        buttonPanel.add(displayButton);
        buttonPanel.add(applyButton);
        buttonPanel.add(clearButton);

        msgLabel = new JLabel();
        msgLabel.setBorder(new EtchedBorder());

        controlPanel = new JPanel(new GridLayout(3, 1));
        controlPanel.add(namePanel);
        controlPanel.add(buttonPanel);
        controlPanel.add(msgLabel);
    }

    private void display() {
        String yearStr, monthStr, dayStr;
        try {
            yearStr = yearTField.getText().trim();
            monthStr = monthTField.getText().trim();
            dayStr = dayTField.getText().trim();
            year = Integer.parseInt(yearStr);
            month = Integer.parseInt(monthStr);
            day = Integer.parseInt(dayStr);
        } catch (Exception e) { 
            msgLabel.setText(e.toString()); 
            return; 
        }

        try {
            String servletQuery = servlet + 
                "?year=" + URLEncoder.encode(yearStr) +
                "&month=" + URLEncoder.encode(monthStr) + 
                "&day=" + URLEncoder.encode(dayStr);
            URL servletUrl = new URL(protocol, host, port, 
                servletQuery);
            URLConnection con = servletUrl.openConnection();
            con.setUseCaches(false);
            ObjectInputStream in = new ObjectInputStream(
                con.getInputStream());
            reservation = (Reservation) in.readObject();
        } catch (Exception e) { 
            msgLabel.setText(e.toString()); 
            return; 
        }
        displayReservation();
        msgLabel.setText("予約状況を表示しました");
    }

    private void apply() {
        if (reservation == null) {
            msgLabel.setText(
                "「予約状況の表示」をクリックしてください");
            return; 
        }
        name = nameTField.getText().trim();
        if (name.length() == 0) { 
            msgLabel.setText("名前を入力してください"); return; 
        }
        reservation.setPerson(name);
        reservation.setYear(year);
        reservation.setMonth(month);
        reservation.setDay(day);

        try {
            URL servletUrl = new URL(protocol, host, port, servlet);
            URLConnection con = servletUrl.openConnection();
            con.setUseCaches(false);
            con.setDoOutput(true);
            ObjectOutputStream out = new ObjectOutputStream(
                con.getOutputStream());
            out.writeObject(reservation);
            out.flush();
            ObjectInputStream in = new ObjectInputStream(
                con.getInputStream());
            Result result = (Result) in.readObject();

            if (result.type == Result.OK) {
                msgLabel.setText("申し込みを受け付けました");
                String servResult = servlet + "?sessionId=" + 
                    result.sessionId;
                servletUrl = new URL(protocol, host, port, servResult);
                getAppletContext().showDocument(servletUrl, "_blank");

            } else if (result.type == Result.NG) {
                Exception e = result.e;
                msgLabel.setText(e.toString());
            } 
        } catch (Exception e) { msgLabel.setText(e.toString()); }
    }

    private void clear () {
        if (reservation == null) {
            msgLabel.setText(
                "「予約状況の表示」をクリックしてください");
            return; 
        }
        for (int row = 0; row < hours.length; row++) {
            for (int col = 1; col < rooms.length; col++) {
                cells[row][col].selected = false;
            }
        }
        repaint();
        msgLabel.setText("選択をすべて取り消しました");
    }

    private void displayReservation() {
        titleLabel.setText("予約状況： " + 
            year + "年" + month + "月" + day + "日");
        rooms = reservation.getRooms();
        hours = reservation.getHours();
        cells = reservation.getCells();

        model = new AbstractTableModel() {
            public String getColumnName(int col) { return rooms[col]; }
            public int getColumnCount() { return rooms.length; }
            public int getRowCount() { return hours.length; }
            public Object getValueAt(int row, int col) { 
                return cells[row][col]; 
            }
        };

        table = new JTable(model);
        scrollPane.setViewportView (table);

        table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
        table.setRowHeight(cellHeight);
        table.setPreferredSize(new Dimension(cellWidth * 
            model.getColumnCount(), cellHeight * model.getRowCount()));
        table.setCellSelectionEnabled(true);
        ListSelectionModel rlsm = table.getSelectionModel(); 
        rlsm.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                checkSelection(e, Row);  // 行選択の変化
            }
        });
        ListSelectionModel clsm = 
            table.getColumnModel().getSelectionModel();
        clsm.addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                checkSelection(e, Col);   // 列選択の変化
            }
        });
        DefaultTableCellRenderer cellRenderer =	
            new DefaultTableCellRenderer() {
            public void setValue(Object cell) { // セルを描画
                if (((Cell) cell).selected) {
                    if (((Cell) cell).name.equals("")) {  // 予約
                        setBackground(new Color(255, 204, 255));
                    } else {                        // キャンセル
                        setBackground(new Color(204, 255, 255));
                    }
                } else {
                    setBackground(Color.white);
                }
                setText(((Cell) cell).name);
            }
        };

        for (int col = 0; col < model.getColumnCount(); col++) {
        TableColumn column = table.getColumnModel().getColumn(col);
            column.setCellRenderer(cellRenderer);
        }
    }

    private void checkSelection(ListSelectionEvent e, int which) {
        if (e.getValueIsAdjusting()) return;  // 余分なイベント
        ListSelectionModel lsm = (ListSelectionModel) e.getSource();
        if (lsm.isSelectionEmpty())  return;  // 選択されていない
        selectedIndex[which] = lsm.getMinSelectionIndex();

        if (++selectedTimes == 2) {
            if (selectedIndex[Col] != 0) {
                boolean b = cells[selectedIndex[Row]]
                    [selectedIndex[Col]].selected;
                cells[selectedIndex[Row]]
                    [selectedIndex[Col]].selected = !b;
            }
            selectedTimes = 0;
            table.clearSelection();  // 選択状態の解除
        }
    }
}
