import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

public class RolloverApplet extends JApplet {
    ImageIcon icon0, icon1;
    JLabel imageLabel;

    public void init() {
        String imageFile0 = getParameter("image0");
        String imageFile1 = getParameter("image1");
        Image image0 = getImage(getCodeBase(), imageFile0);
        Image image1 = getImage(getCodeBase(), imageFile1);
        icon0 = new ImageIcon(image0);
        icon1 = new ImageIcon(image1);

        imageLabel = new JLabel(icon0);
        imageLabel.setToolTipText("もらって！");
        imageLabel.setBorder(new LineBorder(Color.blue));

        imageLabel.addMouseListener(new MouseAdapter() {
            public void mouseEntered (MouseEvent ev) {
                imageLabel.setIcon(icon1);
                repaint();
            }
            public void mouseExited (MouseEvent ev) {
                imageLabel.setIcon(icon0);
                repaint();
            }
        });

        Container contentPane = getContentPane();
        contentPane.add (imageLabel, BorderLayout.NORTH);
    }
}
