package gui;
import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import java.awt.*;

public class Panes extends JFrame {
    public Panes() {
        createComponents ();

	Container contentPane = getContentPane ();
        contentPane.setLayout (new GridBagLayout ());
        GridBagConstraints c = new GridBagConstraints ();

        c.gridx = 0;  c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;  c.weighty = 1.0;
        c.fill = GridBagConstraints.BOTH;
        contentPane.add (jSplitPane, c);

        c.gridx = 0;  c.gridy = 1;
        c.gridwidth = 1;
        contentPane.add (jScrollPane3, c);
  
        c.gridx = 1;  c.gridy = 1;
        contentPane.add (jScrollPane4, c);

	setTitle("JSplitPane, JTabbedPane, JTree");
	setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	setSize(420, 200);
	setVisible(true);
    }

    void createComponents () {
	// JSplitPane
        jScrollPane1 = new JScrollPane ();
        jScrollPane2 = new JScrollPane ();
        jSplitPane = new JSplitPane ();
	jSplitPane.setLeftComponent (jScrollPane1);
	jSplitPane.setRightComponent (jScrollPane2);

	// Left Part of JSplitPane
        jButton1 = new JButton ("Left Part");
        jButton2 = new JButton ("of JSplitPane");
        jPanel1 = new JPanel ();
	jPanel1.add (jButton1);
	jPanel1.add (jButton2);
	jScrollPane1.setViewportView (jPanel1);

	// Right Part of JSplitPane
        jButton3 = new JButton ("Right Part");
        jButton4 = new JButton ("of");
        jButton5 = new JButton ("JSplitPane");
        jPanel2 = new JPanel ();
	jPanel2.setLayout(new BoxLayout (jPanel2, BoxLayout.Y_AXIS));
	jPanel2.add (jButton3);
	jPanel2.add (jButton4);
	jPanel2.add (jButton5);
	jScrollPane2.setViewportView (jPanel2);

	// JTabbedPane
        jTabbedPane = new JTabbedPane ();
        jScrollPane3 = new JScrollPane ();
	jScrollPane3.setViewportView (jTabbedPane);

        jButton6 = new JButton ("JButton");
        jButton7 = new JButton ("of Tab 1");
        jPanel3 = new JPanel ();
	jPanel3.add (jButton6);
	jPanel3.add (jButton7);
	jTabbedPane.addTab ("Tab 1", jPanel3);

        jButton8 = new JButton ("JButton");
        jButton9 = new JButton ("of Tab 2");
        jPanel4 = new JPanel ();
	jPanel4.add (jButton8);
	jPanel4.add (jButton9);
	jTabbedPane.addTab ("Tab 2", jPanel4);

	// JTree
        bulldog = new DefaultMutableTreeNode("Bulldog");
        dog = new DefaultMutableTreeNode("Dog");
	dog.add(bulldog);
        human = new DefaultMutableTreeNode("Human");
        animal = new DefaultMutableTreeNode("Animal");
	animal.add(dog);
	animal.add(human);

        jTree = new JTree (animal);
        jScrollPane4 = new JScrollPane ();
	jScrollPane4.setViewportView (jTree);
    }

    public static void main (String[] args) {
        new Panes ();
    }

    JSplitPane jSplitPane;
    JScrollPane jScrollPane1, jScrollPane2, jScrollPane3, jScrollPane4;
    JTabbedPane jTabbedPane;
    JPanel jPanel1, jPanel2, jPanel3, jPanel4;
    JButton jButton1, jButton2, jButton3, jButton4, jButton5, 
            jButton6, jButton7, jButton8, jButton9;
    JTree jTree;
    DefaultMutableTreeNode animal, dog, bulldog, human;
}
