package net;
import javax.swing.*;
import java.net.*;
import java.io.*;

public class Client extends ChatPanel {
    String userName;
    DataInputStream in;
    DataOutputStream out;

    Client(Socket s, String serverName, String userName) 
        throws IOException {
        this.userName = userName;
        in = new DataInputStream(s.getInputStream());
        out = new DataOutputStream(s.getOutputStream());

        JFrame chatFrame = new JFrame("チャット(クライアント) " + 
            userName + " ---> " + serverName);
        chatFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        chatFrame.getContentPane().add(this);
        chatFrame.setSize(500, 400);
        chatFrame.setVisible(true);

        try {
            out.writeUTF(userName + "さんが入室しました！");
            while (true) {
                String line = in.readUTF();
                recvMessage(line);
            }
        } catch (Exception e) { 
            recvMessage("サーバが接続を終了しました");
        }
    }

    public void sendMessage(String line) {
        try {
            out.writeUTF(userName + ": " + line);
        } catch (Exception e) { System.err.println(e); }
    }
}


