package resource;

/**
 * タンクの役割を果します。
 */
public class Tank {
    private int capacity = 0;
    private int fuel = 0;

    /**
     * タンクを生成します。
     * @param capacity タンクの容量
     * @param fuel 残油量
     */
    public Tank(int capacity, int fuel) {
        this.capacity = capacity;
        this.fuel = fuel;
    }

    /**
     * 残油量を取得します。
     * @return 残油量
     */
    public int getFuel() {
        return fuel;
    }

    /**
     * 残油量を設定します。
     * @param amount 残油量
     */
    public void setFuel(int amount) {
        fuel = amount;
    }

    /**
     * タンクを満タンにします。
     * @return 給油量
     */
    public int fillUp() {
        int amount = capacity - fuel;
        fuel = capacity;
        return amount;
    }
}
