package basic;
import java.io.*;

public class Storage extends Thread {
    private String fileName;
    private Serializable obj = null;
    private boolean go = true;

    public Storage(String fileName) {
        this.fileName = fileName;
    }

    public void keep(Serializable obj) {
        this.obj = obj;
    }

    public void run() {
        while (go) {
            try {
                sleep(1000);  // 1000ms毎にカウンタを保存する
                write();
            } catch (Exception e) { System.err.println(e); }
        }
    }

    public void askStop() {
        go = false;
    }

    public Serializable read() throws Exception {
        FileInputStream fileIn = new FileInputStream(fileName);
        ObjectInputStream objIn = new ObjectInputStream(fileIn);
        obj = (Serializable) objIn.readObject();
        return obj;
    }

    public void write() throws IOException {
        FileOutputStream fileOut = new FileOutputStream(fileName);
        ObjectOutputStream objOut = new ObjectOutputStream(fileOut);
        objOut.writeObject(obj);
        objOut.flush();
    }
}
