/****************************************************************
   system.cc  ƥ³

****************************************************************/

using namespace std;

#include <stdio.h>
#include <math.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "machine.h"
#include "system.h"
#include "sysproc.h"

using namespace machine;


// ̵̾̾֡ʤΥեͭ
namespace  {

using namespace systemFuncLib;

// ڥξ
enum PenStatus { PenUp, PenDown };

// ڥο PenColNum ϿοͿ뤿Υߡǡ
enum PenColor { PenBlack, PenRed, PenBlue, PenGreen, PenYellow, 
                PenOrange, PenViolet, PenColNum };

// ڥο̾ɽʸʾ enum PenColor б
static const char *penColorName[PenColNum] = 
    { "black", "red", "blue", "green", "yellow", "orange", "violet" };

// ڥοΥԥͤǼ
unsigned long penColorTable[PenColNum];

// ȥ륰եåѤ

const int WindowXRatio = 1;	// ̾Ψʲ
const int WindowYRatio = 1;	// ̾Ψʽġ

// ȥ륰եåѤŪѿ

PenStatus pen = PenDown;	// ڥξ
PenColor penColor = PenBlack;	// ڥο
double tx;			// ڥΰ֡x
double ty;			// ڥΰ֡y
double direction;		// ڥʾջײ
long sleepTime;			// ٻ߻֡ʥޥá
unsigned int charRead;


#define mapX(x)  (WindowXSize/2 + (int)((x)/WindowXRatio))
#define mapY(y)  (WindowYSize/2 - (int)((y)/WindowYRatio))
#define toRadian(x) ((x)*M_PI/180)
#define toDegree(x) ((x)*180/M_PI)

// ȥۡ˰ư
void setTurtleHome()
{
  tx = ty = 0.0;
  direction = 0.0;
}

void setPenColor(PenColor c)
{
  // staticѿpenColor˿򥻥åȤƤ顢ʿѹ
  penColor = c;
  XSetForeground(display,gc,penColorTable[penColor]);
}

/************************************
  饷ƥ³
************************************/

// ȥʡव륷ƥ³
void sysMove(void)
{
  double distance = stack[sp-1];
  double rx = tx + distance * sin(toRadian(direction));
  double ry = ty + distance * cos(toRadian(direction));

  // ڥ󤬹ߤƤʤ
  if (pen == PenDown)
    XDrawLine(display,window,gc,mapX(tx),mapY(ty),mapX(rx),mapY(ry));

  tx = rx;
  ty = ry;
  sp--;
  XFlush(display);
  usleep(sleepTime);
}

// ȥž륷ƥ³
void sysTurn(void) { direction += stack[sp-1]; sp--; }

// ȥͿ줿֤֤ƥ³
void sysSetPos(void)
{
  tx = stack[sp-2]; ty = stack[sp-1];
  sp -= 2;	// ΰ
}

// ȥͿ줿˸륷ƥ³
void sysSetDirection(void) { direction = stack[sp-1]; sp--; }

// ȥXɸ֤ƥ³
void sysGetX(void) { stack[sp++] = tx; }

// ȥYɸ֤ƥ³
void sysGetY(void) { stack[sp++] = ty; }

// ȥθƤʳ١ˤ֤ƥ³
void sysGetDirection(void) { stack[sp++] = direction; }

// ȥθ֤߰鸫ȤͿ줿ɸ֤ƥ³
void sysTowards(void)
{
  double dx = stack[sp-2] - tx;
  double dy = stack[sp-1] - ty;
  sp -= 2;
  double rad = (fabs(dx) == 0.0) ? M_PI_2 : atan(dy/dx);
  // ֤ͤ-180180δ֤ˤʤ褦ˤ
  if (dx < 0.0)
    rad = -M_PI_2 - rad;
  else
    rad = M_PI_2 - rad;
  stack[sp++] = toDegree(rad);
}

// ȥθ֤߰Ϳ줿ɸޤǤεΥ֤ƥ³
void sysGetDistance(void)
{
  double rx = stack[sp-2], ry = stack[sp-1];
  sp--;
  stack[sp-1] = sqrt((tx-rx)*(tx-rx)+(ty-ry)*(ty-ry));
}

// ڥο򥻥åȤ륷ƥ³
void sysSetPenColor(void)
{
  PenColor c = (PenColor)stack[sp-1];
  if (c >= PenBlack && c < PenColNum)  {
    setPenColor(c);
  }
  else
    fprintf(stderr,"ٹ: ϰϤ0%dޤǤǤ\n",PenColNum);
  sp--;
}

// ڥο֤ƥ³
void sysGetPenColor(void) { stack[sp++] = penColor; }

// 󥿥ץ꥿Ѱդڥο֤ƥ³
void sysGetPenColorNum(void) { stack[sp++] = PenColNum; }

// ɽ֤ƥ³
void sysPenBlack() { stack[sp++] = PenBlack; }

// ֿɽ֤ƥ³
void sysPenRed() { stack[sp++] = PenRed; }

// Ŀɽ֤ƥ³
void sysPenBlue() { stack[sp++] = PenBlue; }

// пɽ֤ƥ³
void sysPenGreen() { stack[sp++] = PenGreen; }

// ɽ֤ƥ³
void sysPenYellow() { stack[sp++] = PenYellow; }

// ɽ֤ƥ³
void sysPenOrange() { stack[sp++] = PenOrange; }

// 翧ɽ֤ƥ³
void sysPenViolet() { stack[sp++] = PenViolet; }

// Ϳ줿ֹμοֹ֤ƥ³
void sysGetNextColor()
{
  stack[sp-1] = (double)(((int)stack[sp-1]+1) % PenColNum);
}

// ڥ򲼤ƥ³
void sysPenDown(void) { pen = PenDown; }

// ڥ夲륷ƥ³
void sysPenUp(void) { pen = PenUp; }

// ̤򥯥ꥢ륷ƥ³
void sysClear(void)
{
  XClearWindow(display,window);  
}

// ȥ֤̤ۡ˸륷ƥ³
void sysHome(void) { setTurtleHome(); }

// 줿ɤ֤ƥ³
void sysIsKeyPressed(void)
{
  bool result = false;

  // ɤʸޤФƤʤʤ鿿֤
  if (charRead)
    result = true;
  else  {
    // ̤٥ȤФ
    // ˥٥ȤʸФ֤
    int q = XEventsQueued(display,QueuedAfterReading);
    while (q--)  {
      XEvent e;
      char c;
      KeySym ksym;
      XNextEvent(display,&e);
      if (e.type == KeyPress)  {
        XLookupString((XKeyPressedEvent *)&e,&c,1,&ksym,NULL);
        charRead = c;
        result = true;
        break;
      }
    }
  }
  stack[sp++] = (double)result;
}  

// ܡɤϤ줿ʸ֤ƥ³
void sysReadChar(void)
{
  if (charRead)  {
    // isKeyPressed() ɤʸĤäƤʤ餽֤
    stack[sp++] = (double)charRead;
    charRead = 0;
  }
  else  {
    // ٥ȤԤʸɤࡣ
    XEvent e;
    char c;
    KeySym ksym;
    while (1)  {
      XNextEvent(display,&e);
      if (e.type == KeyPress)  {
        XLookupString((XKeyPressedEvent *)&e,&c,1,&ksym,NULL);
        break;
      }
    }
    stack[sp++] = (double)c;
  }
}  

// tͿ줿Ȥtߥõٻߤ륷ƥ³
void sysSleep(void)
{
  usleep((int)stack[sp-1]*1000L);
  sp--;
}

// xͿ줿Ȥsin(x)֤ƥ³
void sysSin(void)
{
  stack[sp-1] = sin(toRadian(stack[sp-1]));
}

// xͿ줿Ȥcos(x)֤ƥ³
void sysCos(void)
{
  stack[sp-1] = cos(toRadian(stack[sp-1]));
}

// xͿ줿Ȥsqrt(x)֤ƥ³
void sysSqrt(void)
{
  stack[sp-1] = sqrt(stack[sp-1]);
}

}	// ̵֤̾̾ν


// ̾ systemFuncLib
namespace systemFuncLib  {

Display *display;
Window window;
GC gc;

  //void  setPenColor(PenColor);

void initializeTurtle()
{
  // ȥΰ֤ۡ˰ܤ
  setTurtleHome();
  setPenColor(PenBlack);
}

void initializeColorTable()
{
  Colormap cmap = DefaultColormap(display,0);
  XColor scrCol, exCol;
  int i;

  for (i=0; i != PenColNum; i++)  {
    XAllocNamedColor(display,cmap,penColorName[i],&scrCol,&exCol);
    penColorTable[i] = scrCol.pixel;
  }
  setPenColor(PenBlack);
}

}	// ̾ systemFuncLib ν

#define MaxSleepTime	1000

// Хؿ
void setSpeed(int speed)
{
  if (speed < 0) speed = 0;
  else if (speed > MaxSleepTime) speed = MaxSleepTime;
  sleepTime = speed*1000L;
}


// ƥ³ɽ
const SystemProcDecl sysProcDecl[] = {
  SystemProcDecl("move",		1, true,  sysMove),
  SystemProcDecl("turn", 		1, true,  sysTurn),
  SystemProcDecl("setPos",		2, true,  sysSetPos),
  SystemProcDecl("setDirection",	1, true,  sysSetDirection),
  SystemProcDecl("getX",		0, false, sysGetX),
  SystemProcDecl("getY",		0, false, sysGetY),
  SystemProcDecl("getDirection",	0, false, sysGetDirection),
  SystemProcDecl("towards",		2, false, sysTowards),
  SystemProcDecl("getDistance",		2, false, sysGetDistance),
  SystemProcDecl("setPenColor",		1, true,  sysSetPenColor),
  SystemProcDecl("getPenColor",		0, false, sysGetPenColor),
  SystemProcDecl("getPenColorNum",	0, false, sysGetPenColorNum),
  SystemProcDecl("penBlack",		0, false, sysPenBlack),
  SystemProcDecl("penRed",		0, false, sysPenRed),
  SystemProcDecl("penBlue",		0, false, sysPenBlue),
  SystemProcDecl("penGreen",		0, false, sysPenGreen),
  SystemProcDecl("penYellow",		0, false, sysPenYellow),
  SystemProcDecl("penOrange",		0, false, sysPenOrange),
  SystemProcDecl("penViolet",		0, false, sysPenViolet),
  SystemProcDecl("getNextColor",	1, false, sysGetNextColor),
  SystemProcDecl("penDown",		0, true,  sysPenDown),
  SystemProcDecl("penUp",		0, true,  sysPenUp),
  SystemProcDecl("clear",		0, true,  sysClear),
  SystemProcDecl("home",		0, true,  sysHome),
  SystemProcDecl("isKeyPressed",	0, false, sysIsKeyPressed),
  SystemProcDecl("readChar",		0, false, sysReadChar),
  SystemProcDecl("sleep",		1, true,  sysSleep),
  SystemProcDecl("sin",			1, false, sysSin),
  SystemProcDecl("cos",			1, false, sysCos),
  SystemProcDecl("sqrt",		1, false, sysSqrt) };

// ƥ³ο
const int SystemProcNum = sizeof(sysProcDecl)/sizeof(SystemProcDecl);
