/****************************************************************
   symtable.cc  ɽ

****************************************************************/

using namespace std;

#include <stdio.h>
#include "symtable.h"
#include "sysproc.h"
#include "error.h"


// static ؿΥץȥ
static void addSystemProcedure(SystemProcDecl decl);
static VarEntry *addVariable(string name, VarClass vclass, SymbolTable *table);
static ProcEntry *addProcedure(string name, ProcClass pclass, int params);
static ProcEntry *defineProcedure(string name, ProcClass pclass);
static ProcEntry *findProcedure(string name);
static SymbolEntry *find(string name, SymbolTable *table);
static void clearAll(SymbolTable *table);

// static ѿ

static SymbolTable globalSymTable;	// Ūʵɽ
static SymbolTable localSymTable;	// ɽŪʵɽ

static int localVarLocation;		// ɽѿΥե졼
static int paramLocation;		// Υե졼

// ³μ̤ɽʸ
static char *pclassStr[] = { "ؿ", "ޥ" };


// ץΥѥ뽪λˡѤΥ桼³
// ٤줿ɤĴ٤ؿ
// 줿ΤƤʤؿä饨顼𤹤
void checkProgram()
{
  SymbolTable::iterator it, ie = globalSymTable.end();
  // ŪʵɽΥȥĴ٤
  for (it=globalSymTable.begin(); it != ie; it++)  {
    SymbolEntry *symbol = it->second;
    // Υȥ꤬桼³ȥǡ̤ʤ饨顼𤹤
    if (symbol->isProcedure() && !((ProcEntry *)symbol)->isDefined())
      compileError(EProcNotDefined,symbol->getName().c_str());
  }
}

// ɽν
void initializeSymbolTable()
{
  // ɽ˥ƥ³ΤΥȥɲä
  for (int i=0; i<SystemProcNum; i++) {
    addSystemProcedure(sysProcDecl[i]);
  }
  // ɽ main ޥɤΤΥȥɲä
  addCommand("main",0);
}

// ɽΥꥢ
void clearSymbolTable()
{
  // Ūʵɽ򥯥ꥢ
  clearAll(&globalSymTable);
  // ɽŪʵɽ򥯥ꥢ
  clearAll(&localSymTable);
}

// ƥ³εɽؤϿ
static void addSystemProcedure(SystemProcDecl decl)
{
  ProcClass pclass = decl.isCommand() ? ProcComm : ProcFunc;
  const char *name = decl.getName();
  int paramNum = decl.getParamNum();
  SystemProc sysProc = decl.getSystemProc();
  // ̾namepclass Υƥ³Τ
  // ȥŪʵɽϿ
  ProcEntry *proc = new ProcEntry(pclass,name,paramNum,sysProc);
  globalSymTable.insert(make_pair(name,proc));
  // ³Ѥߤˤ
  proc->define();
}

// ѿΤѿȥŪʵɽϿ
// ϿѿȥؤΥݥ󥿤֤
VarEntry *addGlobalVariable(string name)
{
  return addVariable(name,GlobalVar,&globalSymTable);
}

// ɽѿΤѿȥɽŪʵɽϿ
// ϿѿȥؤΥݥ󥿤֤
VarEntry *addLocalVariable(string name)
{
  VarEntry *var = addVariable(name,LocalVar,&localSymTable);
  var->setLocation(localVarLocation++);
  return var;
}

// ΤѿȥɽŪʵɽϿ
// ϿѿȥؤΥݥ󥿤֤
VarEntry *addParameter(string name)
{
  VarEntry *var = addVariable(name,Param,&localSymTable);
  var->setLocation(paramLocation++);
  return var;
}

// ̻̾nameѿμvcѿȥ
// tableؤɽˤѿȥϿ
// ϿѿȥؤΥݥ󥿤֤
static VarEntry *addVariable(string name, VarClass vc, SymbolTable *table)
{
  // Ʊ̾μ̻ҤͿ줿ɽ¸ߤ뤫åХ顼
  SymbolEntry *symbol = find(name,table);
  if (symbol != NULL)  {
    if (symbol->isVariable())
      compileError(EVarDuplicated,name.c_str());
    else
      compileError(EAlreadyAsProc,name.c_str());
  }
  // ʤм̻̾namevclassѿͿ줿ɽϿ
  VarEntry *var = new VarEntry(vc,name);
  table->insert(make_pair(name,var));
  return var;
}

// 桼ؿεɽؤϿ
ProcEntry *addFunction(string name, int params)
{
  return addProcedure(name, ProcFunc, params);
}

// 桼ޥɤεɽؤϿ
ProcEntry *addCommand(string name, int params)
{
  return addProcedure(name, ProcComm, params);
}

// 桼³εɽؤϿ
static ProcEntry *addProcedure(string name, ProcClass pclass, int paramNum)
{
  // ̾nameļ̻ҤŪʵɽϿѤʤ饨顼
  SymbolEntry *symbol = find(name,&globalSymTable);

  if (symbol != NULL)  {
    if (symbol->isProcedure())
      compileError(EProcDuplicated,name.c_str());
    if (symbol->isVariable())
      compileError(EAlreadyAsVar,name.c_str());
  }
  // ̾namepclassΥ桼³ŪʵɽϿ
  ProcEntry *proc = new ProcEntry(pclass,name,paramNum);
  globalSymTable.insert(make_pair(name,proc));
  return proc;
}

ProcEntry *defineFunction(string name)
{
  return defineProcedure(name,ProcFunc);
}

ProcEntry *defineCommand(string name)
{
  return defineProcedure(name,ProcComm);
}

static ProcEntry *defineProcedure(string name, ProcClass pclass)
{
  ProcEntry *proc = findProcedure(name);

  // ³Ѥߤʤ饨顼
  if (proc->isDefined())
    compileError(EProcDefDuplicated,name.c_str());

  // ³μ̤Ȱۤʤʤ饨顼
  if (proc->getProcClass() != pclass)
    compileError(EProcClassMismatch,name.c_str(),
                 pclassStr[pclass],pclassStr[proc->getProcClass()]);

  // ɽѿȲΥե졼а֤ݻѿ
  localVarLocation = 1;
  paramLocation = - proc->getParamNumber();

  // ɽŪʵɽ򥯥ꥢ
  clearAll(&localSymTable);

  // ³Ѥˤ(ХåѥåԤ)
  proc->define();

  // ³ȥؤΥɥ쥹֤
  return proc;
}

// ̻̾nameѿȥ򵭹ɽõ
// Ĥä餽ѿȥؤΥݥ󥿤֤
// ĤʤХ顼
VarEntry *findVariable(string name)
{
  SymbolEntry *var = find(name,&localSymTable);

  // ɽŪʵɽ˼̻nameĵɽȥ꤬ʤС
  // Ūʵɽ鼱̻nameĵɽȥõ
  if (var == NULL)
    var = find(name,&globalSymTable);

  // ɽȥ꤬ĤʤХ顼
  if (var == NULL)
    compileError(EVarNotDeclared,name.c_str());
  // ³ȥ꤬Ĥä饨顼
  else if (var->isProcedure())
    compileError(EDeclaredAsProc,name.c_str());
  // ĤäѿȥؤΥݥ󥿤֤
  else
    return (VarEntry *)var;
}

ProcEntry *findCommand(string name)
{
  ProcEntry *proc = findProcedure(name);
  if (proc->isFunction())
    compileError(ECalledAsFunc,name.c_str());
  return proc;
}

ProcEntry *findFunction(string name)
{
  ProcEntry *proc = findProcedure(name);
  if (proc->isCommand())
    compileError(ECalledAsComm,name.c_str());
  return proc;
}

static ProcEntry *findProcedure(string name)
{
  SymbolEntry *symbol = find(name,&globalSymTable);

  // ɽȥ꤬ĤʤХ顼
  if (symbol == NULL)
    compileError(EProcNotDeclared,name.c_str());// ³̤
  // ѿȥ꤬Ĥä饨顼
  else if (!symbol->isProcedure())
    compileError(EDeclaredAsVar,name.c_str());	// ѿȤƤ
  // ³ȥؤΥݥ󥿤֤
  else
    return (ProcEntry *)symbol;
}

// ̻̾nameĵɽȥtableؤɽõ
// Ĥä餽εɽȥؤΥݥ󥿤򡢸Ĥʤ
// NULL֤
static SymbolEntry *find(string name, SymbolTable *table)
{
  SymbolTable::iterator it = table->find(name);
  if (it == table->end())
    return NULL;
  else
    return it->second;
}

void checkParamNumber(int paramNum, ProcEntry *proc)
{
  if (proc->getParamNumber() != paramNum)
    compileError(EParamNumMismatch,proc->getName().c_str(),
		 paramNum,proc->getParamNumber());
}

static void clearAll(SymbolTable *table)
{
  SymbolTable::iterator it,ie = table->end();

  // SymbolTable ͤϵɽȥؤΥݥ󥿤
  // map clear() ᥽åɤǤϡΥݥ󥿤ؤɽȥ
  // ʤΤᡤtable γǤФơ줬ؤ
  // ɽȥ򤹤٤Ʋɬפ롥
  for (it=table->begin(); it != ie; it++)
    delete it->second;

  // ɽ򥯥ꥢ
  table->clear();
}

