/*
 * 쐬: 2008/07/13
 * author: Taro Suzuki
 *
 * L\̎葱Gg̒`
 * 
 */
package tgl.compiler;

import tgl.interpreter.SystemProc;
import tgl.stree.Code;
import tgl.stree.STree;

/**
 * L\̎葱Gg\B葱ɊւۑB
 * ۑ́A葱ǍA[U`葱̏ꍇ
 * {̂̃R[hAVXe`葱̏ꍇ̓VXe`葱\
 * NX̃CX^XA葱̎ʁi֐R}hjB
 */
class ProcEntry extends SymbolEntry {
  private boolean defined;
  private int paramNum;
  private Code code;
  private SystemProc system;
  private ProcClass pclass;

  /**
   * [U`葱i[L\Gg쐬B
   * 葱̒`͌ŗ^̂ŁA쐬ɂ͎葱͖`B
   * @param pclass 葱̎ʁiR}hA֐j
   * @param name 葱
   * @param paramNum 葱̈
   */ 
  ProcEntry(ProcClass pclass, String name, int paramNum) {
    super(SymClass.Procedure,name);
    initialize(paramNum,pclass,new Code(),null);
  }
  
  /**
   * VXe`葱i[L\Gg쐬B
   * GgɃVXe`葱̒`^̂ŁA
   * 葱͒`ς݂ł邱ƂGgɋLB
   * @param pclass 葱̎ʁiR}hA֐j
   * @param name 葱
   * @param paramNum 葱̈
   * @param system VXe`葱̒`
   */
  ProcEntry(ProcClass pclass, String name, int paramNum, SystemProc system) {
    super(SymClass.Procedure,name);
    initialize(paramNum,pclass,null,system);
    // 葱`ς݂ɂ
    defined = true;
  }

  // CX^Xϐ̏
  private void initialize(int paramNum, ProcClass pclass, Code code, SystemProc system) {
    this.paramNum = paramNum;
    this.pclass = pclass;
    this.code = code;
    this.system = system;
  }


  // R}h֐𒲂ׂ邽߂̏q
  /**
   * 葱R}hǂׂB
   * @return R}hȂ trueA֐Ȃ false
   */
  boolean isCommand() {
    return pclass == ProcClass.Command;
  }
  /**
   * 葱֐ǂׂB
   * @return ֐Ȃ trueAR}hȂ false
   */
  boolean isFunction() {
    return pclass == ProcClass.Function;
  }

  /**
   * 葱̎ʂ擾B
   * @return 葱̎
   */
  ProcClass getProcClass() {
    return pclass;
  }

  /**
   * 葱̈擾
   * @return 
   */
  int getParamNumber() {
    return paramNum;
  }

  /**
   * 葱`ς݂ǂׂB
   * @return `ς݂Ȃ trueA`Ȃ false
   */
  boolean isDefined() {
    return defined;
  }

  /**
   * 葱`ς݂ɂB
   */
  void define() {
    defined = true;
  }

  /**
   * VXe`葱ǂׂB
   * @return VXe`葱Ȃ trueA[U`葱Ȃ false
   */
  boolean isSystemDefined() {
    return system != null;
  }
  /**
   * [U`葱ǂׂB
   * @return [U`葱Ȃ trueA葱`葱Ȃ false
   */
  boolean isUserDefined() {
    return system == null;
  }

  /**
   * [U`Ŝ߂̒ԃR[ḧ擾B
   * @return [U`Ŝ߂̒ԃR[ḧ
   */
  Code getCode() {
    return code;
  }

  /**
   * VXe`葱̂߂̒`łIuWFNg擾B
   * @return VXe`葱̂߂̃IuWFNg
   */
  SystemProc getSystemProcedure() {
    return system;
  }

  /**
   * [U`葱̂߂̒ԃR[ḧɍ\؂ǉB
   */
  void addCode(STree tree) {
    code.add(tree);
  }
}


/**
 * 葱̎ʂ\萔񋓂B
 */
enum ProcClass {
  Function ("֐"),
  Command ("R}h");

  private final String print;

  ProcClass(String name) {
    print = name;
  }

  /**
   * 萔ɑΉ镶擾B
   */
  public String toString() {
    return print;
  }
}
