/****************************************************************
   symtable.h  ɽȥΥ饹ʤɤ

****************************************************************/

#ifndef __SYMTABLE_H__
#define __SYMTABLE_H__

#include <string>
#include <map>
#include "code.h"


// ɽȥμ  SymVar: ѿ, SymProc: ³
enum SymClass { SymVar, SymProc };

// ѿμ  GlobalVar: ѿ, LocalVar: ɽѿParam: 
enum VarClass { GlobalVar, LocalVar, Param };

// ³μ  ProcFunc: ؿ, ProcComm: ޥ
enum ProcClass { ProcFunc, ProcComm };

// 桼³(UserProc)ȥƥ³(SysProc)μ
enum ProcDef { UserProc, SysProc };


// ɽȥ 
class SymbolEntry  {
  SymClass _class;	// ɽȥμ
  string _name;		// ̻̾ʥ顼ѡ
 public:
  // 󥹥ȥ饯
  SymbolEntry(SymClass c, string name) : _class(c), _name(name)  { }
  // ɽȥμ̤Ĵ٤뤿νҸ
  bool isVariable() { return _class == SymVar; }
  bool isProcedure() { return _class == SymProc; }
  // ̻̾˥뤿Υдؿ
  string getName() { return _name; }
};

// ɽη̾
typedef map<string, SymbolEntry *> SymbolTable;


// ѿȥʵɽȥΥ֥饹
class VarEntry : public SymbolEntry {
  VarClass _vclass;	// ѿμ
  int _location;	// ѿΤȤ: ѿŪǡΰ
			// ʳΤȤ: ѿΥե졼
 public:
  // 󥹥ȥ饯
  VarEntry(VarClass vc, string name) : SymbolEntry(SymVar,name)  {
    _vclass = vc;	// ѿ _vclassν
  }
  // ѿμ̤Ĵ٤뤿νҸ
  bool isGlobalVariable() { return _vclass == GlobalVar; }
  bool isLocalVariable() { return _vclass == LocalVar; }
  bool isParameter() { return _vclass == Param; }
  // ѿ˳Ƥ줿Ϥ˥뤿Υдؿ
  int getLocation() { return _location; }
  void setLocation(int location) { _location = location; }
};

// ³ȥʵɽȥΥ֥饹
class ProcEntry : public SymbolEntry {
  ProcClass _pclass;	// ³μ̡ʥޥɤؿ
  int _paramNum;	// Ŀ
  Code *_code;		// 桼³֥
  SystemProc _system;	// ƥ³ؤΥݥ󥿤ޤNULL
  bool _defined;	// Ѥʤtrue̤ʤfalse
  ProcDef _procDef;	// ƥ³桼³
 public:
  // 桼³ΤΥ󥹥ȥ饯
  ProcEntry(ProcClass pclass, string name, int paramNum)
    : SymbolEntry(SymProc,name), _defined(false), _code(new Code),
      _paramNum(paramNum), _pclass(pclass),
      _procDef(UserProc), _system(NULL) { }
  // ƥ³ΤΥ󥹥ȥ饯
  ProcEntry(ProcClass pclass, string name, int paramNum, SystemProc system)
    : SymbolEntry(SymProc,name), _defined(false), _code(NULL),
      _paramNum(paramNum), _pclass(pclass),
      _procDef(SysProc), _system(system) { }
  // ޥɤؿĴ٤뤿νҸ
  bool isCommand() { return _pclass == ProcComm; }
  bool isFunction() { return _pclass == ProcFunc; }
  // ³̤ؤΥ
  ProcClass getProcClass() { return _pclass; }
  // ĿؤΥ
  int getParamNumber() { return _paramNum; }
  // ѥե饰ؤΥ
  bool isDefined() { return _defined; }	// ³Ѥ
  // ³Ѥˤ
  void define() { _defined = true; }
  // ƥ³桼³?
  bool isSystemDefined() { return _procDef == SysProc; }
  bool isUserDefined() { return _procDef == UserProc; }
  // 桼³Τ֥ΰФ
  Code *getCode() { return _code; }
  // ƥ³Τδؿݥ󥿤Ф
  SystemProc getSystemProcedure() { return _system; }
  // 桼³Τ֥ΰ˹ʸڤɲä
  void addCode(STree *tree) { _code->push_back(tree); }
};

/* symboltable.cc δؿץȥ */

void initializeSymbolTable(void);
void clearSymbolTable(void);
void checkProgram(void);
VarEntry *addGlobalVariable(string name);
VarEntry *addLocalVariable(string name);
VarEntry *addParameter(string name);
ProcEntry *addFunction(string name, int params);
ProcEntry *addCommand(string name, int params);
ProcEntry *defineFunction(string name);
ProcEntry *defineCommand(string name);
VarEntry *findVariable(string name);
ProcEntry *findCommand(string name);
ProcEntry *findFunction(string name);
void checkParamNumber(int paramNum, ProcEntry *proc);

#endif
