/*
 * 쐬: 2008/07/14
 * author: Taro Suzuki
 *
 * RpCG[̃nh̒`
 * 
 */
package tgl.compiler.error;

import tgl.compiler.Parser;


/**
 * RpCG[G[nh\B
 * G[\NX XXX ɑ΂āÃG[ caseXXX Ƃ
 * Õ\bhpӂĂB̃\bhł́Atglc.cup Œ`
 * Ă郁\bh report_fatal_error ɃG[bZ[WnB
 * repot_fatal_error ́A󂯎G[bZ[W\ăG[񍐂A
 * \͊~ĂO ParseException 𔭐B
 */
public class CompileErrorHandler  {
  Parser parser;
  int line = 0;
  int col = 0;
  String filename;

  /**
   * RpCɔG[̃nh̃IuWFNg쐬B
   * @param name RpC錴nvÕt@C
   */
  public CompileErrorHandler(String name) {
    filename = name;
  }

  /**
   * \͊̃CX^XIuWFNgۑB
   * @param obj \͊̃CX^XIuWFNg
   */
  public void setParser(Parser obj)  {
    parser = obj;
  }

  /**
   * G[N\̂g[N̈ʒuۑB
   * ʒu͍sƌŕ\B
   * @param l siŏ̍sOƂj
   * @param c iŏ̌OƂj
   */
  public void setTokenLocation(int l, int c) {
    line = l;
    col = c;
  }

  /**
   * 葱Ăяö̌錾ƈvȂƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseParamNumMismatchError(ParamNumMismatchError e) throws Exception {
    reportParserError("葱" + e.getName() + "̈" +
        e.getExpectedNum() + "łȂ" + e.getSpecifiedNum() + "Kvł");
  }

  /**
   * 錾ς̎葱`ĂȂƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseProcNotDefinedError(ProcNotDefinedError e) throws Exception {
    reportParserError("錾ꂽ葱" + e.getName() + "̒`܂");
  }

  /**
   * R}h̒`Ɍ return ɖ߂lw肳ĂƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseReturnValueError(ReturnValueError e) throws Exception {
    reportParserError("R}h" + e.getName() + "returnŒlԂĂ܂");
  }

  /**
   * ֐̒`Ɍ return ̖߂lw肳ĂȂƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseNotReturnValueError(NotReturnValueError e) throws Exception {
    reportParserError("֐" + e.getName() + "returnŒlԂĂ܂");
  }

  /**
   * O[oϐƂĐ錾ꂽʎq葱ƂĐ錾ƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseAlreadyAsVarError(AlreadyAsVarError e) throws Exception {
    reportParserError("ʎq" + e.getName() + "͕ϐƂĊɐ錾Ă܂");
  }

  /**
   * 葱ƂĐ錾ꂽʎqO[oϐƂĐ錾ƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseAlreadyAsProcError(AlreadyAsProcError e) throws Exception {
    reportParserError("ʎq" + e.getName() + "͎葱ƂĊɐ錾Ă܂");
  }

  /**
   * ϐd錾ƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseVarDuplicationError(VarDuplicationError e) throws Exception {
    reportParserError("ϐ" + e.getName() + "͊ɐ錾Ă܂");
  }

  /**
   * 葱d錾ƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseProcDuplicationError(ProcDuplicationError e) throws Exception {
    reportParserError("葱" + e.getName() + "͊ɐ錾Ă܂");
  }

  /**
   * 葱d`ƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseProcDefDuplicationError(ProcDefDuplicationError e) throws Exception {
    reportParserError("葱" + e.getName() + "͊ɒ`Ă܂");
  }

  /**
   * 葱̐錾ł̎ʂƒ`ł̎ʂقȂƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseProcKindMismatchError(ProcKindMismatchError e) throws Exception {
    reportParserError("葱" + e.getName() + "" +
                e.getSpecifiedKind() + "ł͂Ȃ" + e.getExpectedKind() + 
                "ƂĒ`Ă");
  }

  /**
   * 錾ĂȂϐgpƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseVarNotDeclaredError(VarNotDeclaredError e) throws Exception {
    reportParserError("錾ĂȂϐ" + e.getName() + "gpĂ܂");
  }

  /**
   * 錾ĂȂ葱ĂяoƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseProcNotDeclaredError(ProcNotDeclaredError e) throws Exception {
    reportParserError("錾ĂȂ葱" + e.getName() + "gpĂ܂");
  }

  /**
   * ϐƂĐ錾ꂽʎq葱ƂĎgpƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseDeclaredAsVarError(DeclaredAsVarError e) throws Exception {
    reportParserError("ʎq" + e.getName() + "͎葱ł͂Ȃϐł");
  }

  /**
   * 葱ƂĐ錾ꂽʎqϐƂĎgpƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseDeclaredAsProcError(DeclaredAsProcError e) throws Exception {
    reportParserError("ʎq" + e.getName() + "͕ϐł͂Ȃ葱ł");
  }

  /**
   * ֐R}hƂČĂяoƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseDeclaredAsFuncError(DeclaredAsFuncError e) throws Exception {
    reportParserError("֐" + e.getName() + "R}hƂČĂяoĂ܂");  
  }

  /**
   * R}h֐ƂČĂяoƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseDeclaredAsCommError(DeclaredAsCommError e) throws Exception {
    reportParserError("R}h" + e.getName() + "֐ƂČĂяoĂ܂");
  }

  /**
   * \̓G[G[񍐂B
   * @param e G[\CX^X
   */
  void caseSyntaxError(SyntaxError e) throws Exception {
    reportParserError("\G[ł");
  }

  /**
   * ͊킪sȕǂ񂾂ƂɔG[񍐂B
   * @param e G[\CX^X
   */
  void caseIllegalCharError(IllegalCharError e) {
    char c = e.getCharacter();
    parser.report_error(errorMessage(c + " (16iR[h: " + Integer.toHexString(c) + ") ͕sȕł"),null);
    throw new ScannerError();
  }

  /**
   * 萔NH[gȂƂɔG[񍐂B
   * ̃G[͎͊ŔB
   * @param e G[\CX^X
   */
  void caseUnclosedCharError(UnclosedCharError e) {
    parser.report_error(errorMessage("萔NH[g(')܂"),null);
    throw new ScannerError();
  }

  /**
   * cup ̃\bh report_fatal_error ĂяoăG[IB
   * @param msg G[bZ[W
   */
  private void reportParserError(String msg) throws Exception {
    parser.report_fatal_error(errorMessage(msg),null);
  }

  /**
   * t@CƃG[Ng[N̈ʒuAG[bZ[W̑Oɕt
   * 쐬ĕԂB
   * CX^XĂʒuisƌj͂On܂lȂ̂ŁAꂼP
   * Pn܂悤ɂB
   * @param msg G[bZ[W
   */
  private String errorMessage(String msg) {
    return filename + ":" + (line+1) + ":" + (col+1) + ":" + msg;
  }
}
