/*
 * 쐬: 2008/06/21
 * author: Taro Suzuki
 *
 * tgl ꏈn tglc ̃Ct@C
 *
 */
package tgl;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.JFrame;

import tgl.interpreter.Interpreter;
import tgl.interpreter.SystemProcManager;
import tgl.compiler.Lexer;
import tgl.compiler.Parser;
import tgl.compiler.error.CompileErrorHandler;
import tgl.compiler.error.CompileException;
import tgl.compiler.error.ScannerError;

/**
 * tgľꏈnBtgl ̌nvORpCAvO̊e葱
 * ԃR[hi\؂̗j𐶐BRpCIAEBhEЂƂJA
 * 葱 main ̃R[h̉ߎsɊJnB<br>
 * \͂̉ߒo͂Ƃ́ÃNX̃X^eBbNȃvCx[g
 * ϐ DEBUG_PARSER ̒l true ɂB
 */
public class TGL {
  // \͂̉ߒo͂Ƃ́ADEBUG_PARSER ̒l true ɂB
  private static final boolean DEBUG_PARSER = false;
  private Memory memory;
  private int speed = 0;

  /**
   * tgľꏈñGg|CgB- Ŏn܂0ȏ
   * IvVƁAt@CR}hC󂯎B
   * @param args R}hC̈B
   */
  public static void main(String args[]) {
    new TGL(args);
  }

  /**
   * ꏈñCNX̃CX^X쐬B
   * IvV͂AnvÕt@C󂯎B
   * nvORpCĂAEBhEЂƂJA
   * vO̎葱 main ̒ԃR[h̉ߎs
   * JnB
   * @param args R}hC̈
   */
  private TGL(String args[]) {
    String filename = "";
    int index;

    try  {
      if (args.length < 1) {
        System.err.println("܂");
        usage();
      }
      index = 0;
      // IvVo
      while (args[index].charAt(0) == '-') {
        switch (args[index].charAt(1)) {
        case 's':
          speed = Integer.parseInt(args[index].substring(2));
          break;
        default:
	        System.err.println("ȃIvV " + args[index]);
        }
        index++;
        if (index >= args.length) {
          System.err.println("t@Cw肵Ă");
	        usage();
        }
      }
      filename = args[index++];
      if (index < args.length) {
        System.err.println("܂");
        usage();
      }
      compileAndExecute(filename);
    }
    catch (FileNotFoundException e)  {
      System.err.println("t@C܂: " + filename);
      System.exit(1);
    }
    catch (CompileException e) {
      System.exit(1);
    }
    catch (ScannerError e) {
      System.exit(1);
    }
    catch (Exception e)  {
      System.err.println("Internal error: " + e + ": " + e.getMessage());
      System.exit(1);
    }
    catch (Error e) {
      System.exit(1);
    }
  }

  private void usage() {
    System.err.println("tglc [-s] nvOt@C");
    System.exit(1);
  }

  /**
   * nvÕRpCsB
   * @param filename nvOt@C
   * @throws Exception RpCɔO
   */
  private void compile(final String filename) throws Exception {
    FileReader file = new FileReader(filename);
    prepareCompilation();
    try {
      // ̓t@C̍\
      CompileErrorHandler handler = new CompileErrorHandler(filename);
      Lexer scanner = new Lexer(file);
      scanner.setErrorHandler(handler);
      Parser parser = new Parser(scanner,handler);
      if (DEBUG_PARSER)
        memory = (Memory)parser.debug_parse().value;
      else
        memory = (Memory)parser.parse().value;
    }
    finally  {
      try {
        file.close();
      } catch (IOException e) {
        System.err.println("\[Xt@C" + filename + "̃N[YɎs܂");
        System.exit(1);
      }
    }
  }

  /**
   * nvORpCAɉߎsB
   * @param filename nvÕt@C
   * @throws Exception RpCƉߎsɔO
   */
  private void compileAndExecute(String filename) throws Exception {
    DrawingScreen execWindow = new DrawingScreen();
    final Interpreter interpreter = 
      new Interpreter(new SystemProcManager(execWindow));
    final class InterpretThread extends Thread {
      public void run() {
        interpreter.interpret();
      }
    } 
    compile(filename);
    interpreter.setSpeed(speed);
    prepareExecution(interpreter,execWindow);
    final TGLFrame frame = new TGLFrame(execWindow);
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setVisible(true);
    new InterpretThread().run();
  }

  /**
   * ߎs̑OɕKvȏsB
   * @param interpreter C^v^̃CX^X
   * @param screen C^v^`s
   */
  private void prepareExecution(Interpreter interpreter, DrawingScreen screen) {
    if (memory == null) {
      System.err.println("R[h܂");
      System.exit(1);
    }
    else {
      // RpCR[hȂǂC^v^ɃZbgB
      interpreter.setMemory(memory);
    }
  }

  private void prepareCompilation() {
    memory = null;
  }
}
