/*
 * 쐬: 2008/07/12
 * author: Taro Suzuki
 *
 * C^v^gpX^bN̒`
 * 
 */
package tgl.interpreter;

import java.util.Vector;

/**
 * C^v^gpX^bN\B
 * X^bNƂăxN^gp̂ŁA̎ł̓X^bN|C^݂͑ȂB
 */
class Stack extends Vector<Double> {
  // t[|C^
  // l̓X^bN̒(ʒu 0)wB
 private int fp = 0;


  /**
   * X^bNB
   * X^bNɊi[ꂽׂẴf[^NAAt[|C^
   * X^bN̒w悤ɂB܂Amain ̃t[̍ŏ̋Ǐϐ
   * 1Ԓnɐς܂悤ɁA炩߃f[^ЂƂvbVĂB
   */
  void initialize() {
    removeAllElements();
    fp = 0;
    add(0.0);
  }

  /**
   * t[|C^̒l擾B
   * @return t[|C^̒l
   */
  int getFP() {
    return fp;
  }

  /**
   * X^bN̐擪wCfbNX擾B
   * @return X^bN̐擪wCfbNX
   */
  int getTopIndex() {
    return size() - 1;
  }

  /**
   * X^bNɃf[^ЂƂvbVB
   * @param v X^bNɃvbVf[^
   */
  void push(double v) {
    add(v);
  }

  /**
   * X^bNf[^ЂƂ|bvB
   * @return X^bN|bvꂽf[^
   */
  double pop() {
    return remove(size()-1);
  }

  /**
   *  X^bN̐擪ɂf[^ԂBX^bN̐擪̃f[^
   *  |bvꂸɂ̂܂܃X^bNɎcB
   */
  double peek() {
    return lastElement();
  }

  /**
   * ݂̃t[w肳ꂽʒuɂf[^oB
   * ʒu̓t[|C^wʒȗΈʒuŎw肷B
   * X^bN̏Ԃ͕ωȂB
   * @param index t[̈ʒu
   * @return t[̎w肳ꂽʒuɂf[^
   */
  double getFrameElement(int index) {
    int i = fp + index;
    if (i >= size() || i < 0) {
      System.err.println("t[̕sȈʒu"+index+"l𓾂悤Ƃ܂");
      System.exit(2);
    }
    return get(i);
  }

  /**
   * ݂̃t[̎w肳ꂽʒuɃf[^i[B
   * ʒu̓t[|C^wʒȗΈʒuŎw肷B
   * X^bN̏Ԃ͕ωȂB
   * @param v t[̎w肵ʒuɊi[f[^
   * @param index t[̈ʒu
   */
  void setFrameElement(double v, int index) {
    int i = fp + index;
    if (i >= size() || i < 0) {
      System.err.println("t[̕sȈʒu"+index+"Ƀf[^i[悤Ƃ܂");
      System.exit(2);
    }
    this.setElementAt(v,fp+index);
  }

  /**
   * t[|C^XVB݂̃t[|C^̒lA
   * X^bNɃvbVBt[|C^ޔX^bN
   * ʒuw悤ɁAt[|C^̒lXVB
   */
  void updateFramePointer() {
    add((double)fp);
    fp = size() - 1;
  }

  /**
   * t[|C^̒lAX^bNɑޔĂlɖ߂B
   * Ǐϐ̈ƃt[|C^ޔĂ̈C
   * ޔĂt[|C^t[|C^̒lƂB
   * ɂA̎_܂ŃANeBut[ɑΉ
   * 葱̌Ăяõt[ANeBuɂȂB
   */
  void resumeFramePointer() {
    this.removeRange(fp+1,size());
    fp = (int)pop();    
  }

  /**
   * ̈B
   * @param c ̌
   */
  void releaseParameters(int c) {
    if (c > 0)
      removeRange(size()-c,size());
  }

  /**
  *  X^bNw肳ꂽL΂B
  * ͋Ǐϐ̂߂̗̈̊mۂɎgB
  * dlCǏϐ̏l͖Ȃ̂ŁA
  * mۂׂĂ̗̈ null i[B
  * @param n X^bNL΂
  */
  void extend(int n) {
    while (n-- > 0)
      add(null);
  }
}
