/*
 * 쐬: 2008/07/12
 * author: Taro Suzuki
 *
 * VXe`葱̊ǗƎ葱̏sNX̒`
 *
 */
package tgl.interpreter;

import java.awt.Color;
import tgl.DrawingScreen;


/**
 * VXe`葱̊ǗƎ葱̏sB
 */
public class SystemProcManager {
  private static final int PenUp = 0;
  private static final int PenDown = 1;
  // y̐F\萔
  private static final int PenBlack = 0;
  private static final int PenRed = 1;
  private static final int PenBlue = 2;
  private static final int PenGreen = 3;
  private static final int PenYellow = 4;
  private static final int PenOrange = 5;
  private static final int PenMagenta = 6;
  private static final int MaxSleepTime = 1000;
  private final Color colorTable[] =
    { Color.BLACK, Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW,
      Color.ORANGE, Color.MAGENTA };
  private final int PenColNum = colorTable.length;
  private int pen;
  private int penColor;
  private double direction;
  private double tx;
  private double ty;
  private long sleepTime = 0;
  private DrawingScreen screen;

  /**
   * CX^X쐬B
   * @param w C^v^`sʂ̃CX^X
   */
  public SystemProcManager(DrawingScreen w) {
    screen = w;
    initialize();
  }

  /**
   * ^[gړVXe`R}h̏sB
   * w肳ꂽ^[gOiBȂA̐Βl
   * ނ邱ƂɂȂB
   * @param stack C^v^̃X^bN
   */
  void move(Stack stack)
  {
    // X^bNoBolXŸړ߂
    double distance = stack.getFrameElement(-1);
    double rx = tx + distance * Math.sin(Math.toRadians(direction));
    double ry = ty + distance * Math.cos(Math.toRadians(direction));

    // y~ĂȂ
    if (pen == PenDown)  {
      try {
        screen.drawLine(tx,ty,rx,ry,colorTable[penColor]);
        if (sleepTime != 0)
          Thread.sleep(sleepTime);
      } catch (InterruptedException e) { }
    }
    tx = rx;
    ty = ry;
    stack.resumeFramePointer();          // t[|C^̕A
    stack.releaseParameters(1);          // ̈̉
  }

  /**
   * ^[g]VXe`R}h̏sB
   * w肳ꂽpx^[gvɉ]Bpx̒lȂA
   * ̐Βlvɉ]邱ƂɂȂBpx̒Pʂ͓xŎw肳B
   * @param stack C^v^̃X^bN
   */
  void turn(Stack stack) {
    // X^bNoāA̒l direction ωB
    direction += stack.getFrameElement(-1);
    stack.resumeFramePointer();          // t[|C^̕A
    stack.releaseParameters(1);          // ̈̉
  }

  /**
   * ^[gw肳ꂽʒuɒuVXe`R}h̏sB
   * ^[g̐ΈʒuXWX^bNɐς܂ꂽ1AYW
   * X^bNɐς܂ꂽ2ɂB
   * @param stack C^v^̃X^bN
   */
  void setPos(Stack stack)
  {
    // X^bNXWYW̒loA^[g̈ʒuύXB
    tx = stack.getFrameElement(-2);
    ty = stack.getFrameElement(-1);
    stack.resumeFramePointer();          // t[|C^̕A
    stack.releaseParameters(2);          // ̈̉
  }

  /**
   * ^[gw肳ꂽɌVXe`R}h̏sB
   * Y̐̊̕pxiPʂ͓xjŎw肳B
   * @param stack C^v^̃X^bN
   */
  void setDirection(Stack stack) {
    // X^bNpxoAdirection XVB
    direction = stack.getFrameElement(-1);
    stack.resumeFramePointer();          // t[|C^̕A
    stack.releaseParameters(1);          // ̈̉
  }

  /**
   * ݂̃^[gXWԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void getX(Stack stack) {
    stack.resumeFramePointer();          // t[|C^̕A
    // ݂̃^[gXW̒lX^bNɃvbV
    stack.push(tx);
  }

  /**
   * ݂̃^[gYWԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void getY(Stack stack) {
    stack.resumeFramePointer();          // t[|C^̕A
    // ݂̃^[gYW̒lX^bNɃvbV
    stack.push(ty);
  }

  /**
   * ݂̃^[gĂԂVXe`֐̏sB
   * 葱̖߂ĺAY̐̊̕pxiPʂ͓xjB
   * @param stack C^v^̃X^bN
   */
  void getDirection(Stack stack) {
    stack.resumeFramePointer();          // t[|C^̕A
    // ݂̃^[gĂX^bNɃvbV
    stack.push(direction);
  }

  /**
   * ^[ǧ݈ʒuw肳ꂽʒuւ̊pxԂ
   * VXe`֐̏sB
   * 葱̖߂ĺA -180  180 ̊Ԃ̐ŕ\ꂽA
   * Y̐̊̕pxiPʂ͓xjB
   * @param stack C^v^̃X^bN
   */
  void towards(Stack stack)
  {
    // w肳ꂽʒuXWYWX^bNoA
    // ݂̃^[gXWAYWƂ̍߂
    double dx = stack.getFrameElement(-2) - tx;
    double dy = stack.getFrameElement(-1) - ty;
    // ̍W̍px߂
    double rad = (Math.abs(dx) == 0.0) ? Math.PI/2 : Math.atan(dy/dx);
    // ߂l-180180̊ԂɂȂ悤ɂ
    if (dx < 0.0)
      rad = -Math.PI/2 - rad;
    else
      rad = Math.PI/2 - rad;

    stack.resumeFramePointer();          // t[|C^̕A
    stack.releaseParameters(2);          // ̈̉
    stack.push(Math.toDegrees(rad));     // ߂l̃vbV
  }

  /**
   * ^[ǧ݈ʒu^ꂽW܂ł̋ԂVXe`֐
   * sB
   * @param stack C^v^̃X^bN
   */
  void getDistance(Stack stack)
  {
    // X^bNXWYWo
    double rx = stack.getFrameElement(-2);
    double ry = stack.getFrameElement(-1);

    stack.resumeFramePointer();          // t[|C^̕A
    stack.releaseParameters(2);          // ̈̉
    // ߂ăX^bNɃvbV
    stack.push(Math.sqrt((tx-rx)*(tx-rx)+(ty-ry)*(ty-ry)));
  }

  /**
   * w肵ԍɃy̐FύXVXe`R}h̏sB
   * w肵ԍy̐F̔ԍ͈̔͊OiOȉ PenColNum ȏjł
   * ꍇ́Ay̐FύXɌx\B
   * @param stack C^v^̃X^bN
   */
  void setPenColor(Stack stack)
  {
    int c = (int)stack.getFrameElement(-1);
    if (c >= PenBlack && c < PenColNum)  {
      setPenColor(c);
    }
    else
      System.err.printf("x: F͈̔͂0"+PenColNum+"܂łł");
    stack.resumeFramePointer();            // t[|C^̕A
    stack.releaseParameters(1);            // ̈̉
  }

  /**
   * ݂̃y̐FԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void getPenColor(Stack stack) {
    stack.resumeFramePointer();            // t[|C^̕A
    stack.push((double)penColor);         // ߂l̃vbV
  }

  /**
   * VXepӂy̐FԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void getPenColorNum(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenColNum);       // ߂l̃vbV
  }

  /**
   * F̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penBlack(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenBlack);        // ߂l̃vbV
  }

  /**
   * ԐF̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penRed(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenRed);          // ߂l̃vbV
  }

  /**
   * F̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penBlue(Stack stack) { 
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenBlue);         // ߂l̃vbV
  }

  /**
   * ΐF̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penGreen(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenGreen);        // ߂l̃vbV
  }

  /**
   * F̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penYellow(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenYellow);       // ߂l̃vbV
  }

  /**
   * IWF̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penOrange(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenOrange);       // ߂l̃vbV
  }

  /**
   * F̃y̔ԍԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void penViolet(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    stack.push((double)PenMagenta);      // ߂l̃vbV
  }

  /**
   * ^ꂽy̐F̔ԍ̎̔ԍԂVXe`֐̏sB
   * ^ꂽԍ PenColNum - 1 ɓȂOAȊOȂ
   * ^ꂽԍ1傫ԂB
   * @param stack C^v^̃X^bN
   */
  void getNextColor(Stack stack)
  {
    // X^bNy̐F̔ԍo
    int c = (int)stack.getFrameElement(-1);
    stack.resumeFramePointer();                // t[|C^̕A
    stack.releaseParameters(1);                // ̈̉
    stack.push((double)((c+1) % PenColNum));  // ߂l̃vbV
  }

  /**
   * y낷VXe`R}h̏sB
   * @param stack C^v^̃X^bN
   */
  void penDown(Stack stack) {
    pen = PenDown;                        // y낷
    stack.resumeFramePointer();           // t[|C^̕A
  }

  /**
   * yグVXe`R}h̏sB
   * @param stack C^v^̃X^bN
   */
  void penUp(Stack stack) {
    pen = PenUp;                          // yグ
    stack.resumeFramePointer();           // t[|C^̕A
  }

  /**
   * ʂNAVXe`R}h̏sB
   * @param stack C^v^̃X^bN
   */
  void clear(Stack stack)
  {
    try {
      screen.clear();
    } catch (InterruptedException e) { }
    stack.resumeFramePointer();         // t[|C^̕A
  }

  /**
   * ^[g_ɒuAY̐̕ɌVXe`R}h̏sB
   * @param stack C^v^̃X^bN
   */
  void home(Stack stack) {
    setTurtleHome();
    stack.resumeFramePointer();           // t[|C^̕A
  }

  /**
   * L[ꂽǂԂVXe`֐̏sB
   * ֐̖߂ĺAL[ĂPAĂȂ΂OB
   * @param stack C^v^̃X^bN
   */
  void isKeyPressed(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    // Oɓǂ񂾕܂obt@ɎcĂȂ^Ԃ
    stack.push(screen.isKeyPressed() ? 1 : 0);
  }  

  /**
   * L[{[h͂ꂽԂVXe`֐̏sB
   * ֐̖߂ĺA͂ꂽASCIIR[hB
   * @param stack C^v^̃X^bN
   */
  void readChar(Stack stack) {
    stack.resumeFramePointer();           // t[|C^̕A
    // L[{[h͂ꂽoAX^bNɃvbV
    stack.push(screen.readCharacter());
  }  

  /**
   * w肳ꂽԂsx~VXe`R}h̏sB
   * Ԃ̓~bŎw肳B
   * @param stack C^v^̃X^bN
   */
  void sleep(Stack stack) {
    try {
      // X^bNoԂX[v
      Thread.sleep((long)stack.getFrameElement(-1));
    } catch (InterruptedException e) { }
    stack.resumeFramePointer();           // t[|C^̕A
    stack.releaseParameters(1);           // ̈̉
  }

  /**
   * w肳ꂽpx̐(TCjԂVXe`֐̏sB
   * px͓xŎw肳B
   * @param stack C^v^̃X^bN
   */
  void sin(Stack stack) {
    double v = Math.sin(Math.toRadians(stack.getFrameElement(-1)));
    stack.resumeFramePointer();           // t[|C^̕A
    stack.releaseParameters(1);           // ̈̉
    stack.push(v);                        // ߂l̃vbV
  }

  /**
   * w肳ꂽpx̗](RTCjԂVXe`֐̏sB
   * px͓xŎw肳B
   * @param stack C^v^̃X^bN
   */
  void cos(Stack stack) {
    double v = Math.cos(Math.toRadians(stack.getFrameElement(-1)));
    stack.resumeFramePointer();           // t[|C^̕A
    stack.releaseParameters(1);           // ̈̉
    stack.push(v);                        // ߂l̃vbV
  }

  /**
   * w肳ꂽ̕ԂVXe`֐̏sB
   * @param stack C^v^̃X^bN
   */
  void sqrt(Stack stack) {
    double v = Math.sqrt(Math.toRadians(stack.getFrameElement(-1)));
    stack.resumeFramePointer();           // t[|C^̕A
    stack.releaseParameters(1);           // ̈̉
    stack.push(v);                        // ߂l̃vbV
  }

  /**
   * ^[g̏ԂԂɂB^[g̈ʒu_ɈړA
   * Y̐̕By낷B
   */
  public void initialize() {
    // ^[g̈ʒu_ɈڂAY̐̕
    setTurtleHome();
    // pen낷
    pen = PenDown;
  }

  // ^[g̈ʒu_ɈڂAY̐̕
  private void setTurtleHome() {
    tx = ty = 0.0;
    direction = 0.0;
  }

  // y̐F c ɕύX
  private void setPenColor(int c) {
    penColor = c;
  }


  /**
   * `̋x~Ԃݒ肷B spped@̒l0ȉȂx~A
   * 1000ȏȂ1000~bx~BȊÔƂ́Aspeed ~bx~B
   * @param speed x~鎞(~bP)
   */
  void setSpeed(int speed) {
    if (speed < 0) speed = 0;
    else if (speed > MaxSleepTime) speed = MaxSleepTime;
    sleepTime = speed;
  }

  /**
   * VXe`葱̐錾̂߂̏ێz
   */
  static private SystemProcDecl[] decls = {
    new SystemProcDecl("move",           1, true,  new Move()),
    new SystemProcDecl("turn",           1, true,  new Turn()),
    new SystemProcDecl("setPos",         2, true,  new SetPos()),
    new SystemProcDecl("setDirection",   1, true,  new SetDirection()),
    new SystemProcDecl("getX",           0, false, new GetX()),
    new SystemProcDecl("getY",           0, false, new GetY()),
    new SystemProcDecl("getDirection",   0, false, new GetDirection()),
    new SystemProcDecl("towards",        2, false, new Towards()),
    new SystemProcDecl("getDistance",    2, false, new GetDistance()),
    new SystemProcDecl("setPenColor",    1, true,  new SetPenColor()),
    new SystemProcDecl("getPenColor",    0, false,  new GetPenColor()),
    new SystemProcDecl("getPenColorNum", 0, false, new GetPenColorNum()),
    new SystemProcDecl("penBlack",       0, false, new PenBlack()),
    new SystemProcDecl("penRed",         0, false, new PenRed()),
    new SystemProcDecl("penBlue",        0, false, new PenBlue()),
    new SystemProcDecl("penGreen",       0, false, new PenGreen()),
    new SystemProcDecl("penYellow",      0, false, new PenYellow()),
    new SystemProcDecl("penOrange",      0, false, new PenOrange()),
    new SystemProcDecl("penVoilet",      0, false, new PenViolet()),
    new SystemProcDecl("getNextColor",   1, false, new GetNextColor()),
    new SystemProcDecl("penDown",        0, true,  new PenDown()),
    new SystemProcDecl("penUp",          0, true,  new PenUp()),
    new SystemProcDecl("clear",          0, true,  new Clear()),
    new SystemProcDecl("home",           0, true,  new Home()),
    new SystemProcDecl("isKeyPressed",   0, false, new IsKeyPressed()),
    new SystemProcDecl("readChar",       0, false, new ReadChar()),
    new SystemProcDecl("sleep",          1, true,  new Sleep()),
    new SystemProcDecl("sin",            1, false, new Sin()),
    new SystemProcDecl("cos",            1, false, new Cos()),
    new SystemProcDecl("sqrt",           1, false, new Sqrt())
  };

  /**
   * VXe`葱̐錾̂߂̏ێz擾B
   * @return VXe`葱̐錾̂߂̏ێz
   */
  public static SystemProcDecl[] getAllSystemProcedures() {
    return decls;
  }
}

