/*
 * 쐬: 2008/06/21
 * author: Taro Suzuki
 *
 * C^v^̒`
 *
 */
package tgl.interpreter;

import java.util.ArrayList;
import tgl.Memory;
import tgl.stree.*;

/**
 * RpC\؂̗ߎs邽߂̃\bh񋟂B
 * tgl̏ntglĉ̔łł̎ł́Ae\؂ւ̏s߂
 * Visitorp^[̗pĂB̃NX́A\؂ߎs邽߂
 * rW^ĂB<br>
 * caseXXXƂO\bh́A\؂̃NXXXX̃CX^X
 * ߎs邽߂̏sB
 *
 */
public class Interpreter implements STreeVisitor {
  private Memory memory;
  private SystemProcManager procManager;
  private Stack stack;
  /**
   * return̍\؂ߎsƂɁA葱Ăяo炽ɖ߂邽߂
   * ݂ꂽtOBʏ returnNow ̒l false Areturn̍\؂
   * \bh caseReturnTree ߎsƂ true ɕύXB
   * caseReturnTree Ăяo caseCode iԃR[hߎs郁\bhj́A
   * returnNow ̒l true ɕύX return̍\؂̎̍\؂ߎsɁA
   * caseCode Ăяo\bhɂɕAB<br>
   * caseCallTree ɕA܂ł́As̍\؂̉ߎss킸ɌĂяo
   * \bhւ̕AJԂBcaseCallTree ɕA_ŁAtgl ̎葱Ăяo
   * ܂Ŗ߂ƂɂȂ̂ŁAreturnNow ̒l false ɕύXB
   * @see #caseCallTree(CallTree)
   * @see #caseReturnTree(ReturnTree)
   * @see #caseCode(Code)
   */
  private boolean returnNow = false;
  private static final double True = 1;
  private static final double False = 0;
  

  /**
   * C^v^쐬B
   * @param procManager VXe`葱}lW̃CX^X
   */
  public Interpreter(SystemProcManager procManager) {
    this.procManager = procManager;
    stack = new Stack();
  }

  /**
   * ԃR[ḧAÓIf[^̈܂ރC^v^Ɋi[B
   * @param memory ̃CX^X
   */
  public void setMemory(Memory memory) {
    this.memory = memory;
  }

  /**
   * sXs[hݒ肷B̒l傫ȂقǁAsx
   * xȂB
   * @param speed sXs[hݒ肷邽߂̃p[^
   */
  public void setSpeed(int speed) {
    procManager.setSpeed(speed);
  }

  /**
   * vỎߎssB
   */
  public void interpret() {
    // VXe`葱sɕKvȏs
    procManager.initialize();
    // X^bN̏s
    stack.initialize();
    // 葱 main ̒ԃR[hoāAߎssB
    interpret(memory.getMain());
  }

  /**
   * \؂̗iԃR[hjߎsB
   * @param code \؂̗
   */
  private void interpret(Code code) {
    // code  NULL Ȃ牽Ȃ
    if (code != null)
      code.accept(this);
  }

  /**
   * \؂̗iԃR[hjɊ܂܂\؂A̐擪珇ɉߎsB
   * CX^Xϐ returnNow ̒ltrueȂ΁AOɉߎs\؂
   * return̂̂Areturn{̂Ɋ܂ifAwhileArepeatł邱Ƃ
   * \킷B̂߁AreturnNow ̒l true ̂Ƃ́A̍\؂̉ߎs
   * s킸ɂɒԃR[h̎sIB
   * @param code \؂̗
   * @see #returnNow
   */
  public void caseCode(Code code) {
    for (STree tree : code)  {
      if (returnNow) break;
      tree.accept(this);
    }
  }

  /**
   * ߎsB
   * @param tree ̍\
   */
  public void caseAssignTree(AssignTree tree) {
    tree.getExpression().accept(this);
    double result = stack.pop();
    VarNode var = tree.getVariable();
    int loc = var.getLocation();
    boolean global = var.isGlobal();

    // O[oϐւ̑ȂA̕ϐ̂߂ɐÓIf[^̈撆Ɋmۂ
    // ̈ɁA̕]ʂۑB
    if (global)  {
      if (loc < 0 || loc >= memory.getDataSize())  {
        System.err.println("sG[: "+ var.getName() +
                           "̈ʒuÓIf[^̈̐ʒuwĂ܂");
        System.exit(2);
      }
      memory.setData(loc,result);
    }
    // ȊOȂAt[̂̕ϐ̂߂̗̈ɁA̕]ʂۑB
    else  {
      stack.setFrameElement(result,loc);
    }
  }

  /**
   * ifߎsB^ƂȂɑΉ镶Xg̃R[h
   * ߎsBׂċUƂ́Aelse߂̕Xg
   * R[hߎsB
   * @param tree if̍\
   */
  public void caseIfTree(IfTree tree) {
    ArrayList<CondStmtPair> condStmtList = tree.getCondStmtList();
    // if̏ɏꂽ̂珇Ԃɕ]B
    // ^ɂȂAΉ镶Xg̃R[hߎsĂ
    // if̏IBUɂȂȀ̕]ɈڂB
    for (CondStmtPair pair : condStmtList)  {
      pair.getCondition().accept(this);
      if (stack.pop() == True) {
        interpret(pair.getCode());
        return;
      }
    }
    // ɗׂ̂͂Ă̏sƂB
    // ̂Ƃ else ߂s
    interpret(tree.getElsePart());
  }

  /**
   * whileߎsB^̊ԁA{̂̕Xg̃R[h
   * ߎsB
   * @param tree while̍\
   */
  public void caseWhileTree(WhileTree tree) {
    CondTree cond = tree.getCondition();
    Code body = tree.getBody();

    //  cond ^̊ԁC{ body s
    while (true) {
      cond.accept(this);
      if (stack.pop() == False) break;
      interpret(body);
    }
  }

  /**
   * repeatߎsB̕]ʂɂ茈܂s񐔂A
   * {̂̕Xg̃R[hߎsB
   * @param tree repeat̍\
   */
  public void caseRepeatTree(RepeatTree tree) {
    // 񃋁[vs邩w肷鎮]āA[v̎s񐔂𓾂
    tree.getCount().accept(this);
    int count = (int)rint(stack.pop());

    Code body = tree.getBody();
    // w肳ꂽs񐔂{̂sB
    while (count-- > 0)
      interpret(body);
  }

  /**
   * 葱Ăяo߂̏sB珇Ԃɕ]āA
   * ̒lX^bNɃvbVB[U`葱ĂяoƂ́A
   * Ăяo葱̃t[w悤Ƀt[|C^XVāA
   * 葱{̂̃R[hߎsB葱{̂̉ߎsIA
   * returnNow ̒l false ɕύXBɂA̎葱Ăяo
   * ܂ލ\؂̗񒆂̎̍\؂̉ߎss悤ɁAcaseCode ɓ`B
   * VXe`葱ĂяoƂ́AVXe`葱ɑΉNX
   * execute \bhĂяoB
   * @param tree 葱Ăяo̍\
   * @see #returnNow
   * @see #caseCode(Code)
   * @see SystemProc#execute(SystemProcManager, Stack)
   */
  public void caseCallTree(CallTree tree) {
    // oA擪珇ɕ]ăX^bNɃvbV
    ArrayList<ExprTree> argList = tree.getArguments();
    if (argList != null)  {
      for (ExprTree arg: argList)  {
        // ]Daccept()]ʂX^bNɃvbV
        arg.accept(this);
      }
    }
    // [U`葱VXe葱̔
    if (tree.isSystemProcedure())
      // VXe葱̌Ăяo
      tree.getSystemProcedure().execute(procManager,stack);
    else {
      // t[|C^XV
      stack.updateFramePointer();
      // [U`葱{̂̎s
      interpret(tree.getCode());
      // 葱Ăяo܂Ŗ߂Ă̂ŁCreturnNowfalseɂ
      returnNow = false;
    }
  }

  /**
   * 葱Ăяo֖߂邽߂̏sBt[āA
   * Ăяõt[w悤Ƀt[|C^̒lύXB
   * ߂l̂߂̎w肳ĂȂ΁A̎]l
   * X^bN̐擪ɃvbVꂽԂŌĂяoɖ߂B
   * return̍\؂̉ߎsÍA̍\؂܂ރR[h
   * ̍\؂ߎsɁAɃR[h̉ߎsI
   * Ăяo܂Ŗ߂KvB̂߁Ã\bh̎sł́A
   * CX^Xϐ returnNow ̒l true ɕύXAreturnȌ
   * \؂̉ߎssȂ悤Ƀ\bh caseCode ɓ`B
   * @param tree return̍\
   * @see #returnNow
   * @see #caseCode(Code)
   */
  public void caseReturnTree(ReturnTree tree) {
    // ԂlԂKvȂA]ĕԂl𓾂
    // ͎葱̃[JϐQƂĂ邩Ȃ̂
    // ̎_ł̓t[Ă͂ȂȂ
    STree expr = tree.getExpression();
    double result = 0;
    if (expr != null)  {
      expr.accept(this);
      result = stack.pop();
    }
    stack.resumeFramePointer();                    // Ǐϐ̈ƃt[|C^̉
    stack.releaseParameters(tree.getParamNumber()); // ̈̉
    // ԂlԂKvȂAX^bN̐擪ɕԂlvbV
    if (expr != null)
      stack.push(result);
    // returnNowtrueɂāAΉ葱ďo܂Ŗ߂悤ɂ
    returnNow = true;
  }

  /**
   * Ǐϐ̂߂̗̈t[ɊmۂB̂߂̎w肳
   * Ȃ΁Amۂ̈̒l͂̎]lɂȂBw肳ĂȂ
   * mۂ̈̒l null ɂȂB
   * @param tree Ǐϐ錾̍\
   */
  public void caseLocalVarTree(LocalVarTree tree) {
    STree expr = tree.getExpression();
    // Ǐϐ鎮w肳ĂȂA̎]B
    // ̒l̓X^bN̐擪ɐς܂ĂB
    if (expr != null)
      expr.accept(this);
    else
      stack.extend(1);
  }

  /**
   * 񍀉Zq]B]ʂ̓C^v^
   * X^bN̐擪ɐς܂B
   * @param tree 񍀉Zq̍\
   */
  public void caseBinExprTree(BinExprTree tree) {
    tree.getFirstOperand().accept(this);
    double v1 = stack.pop();
    tree.getSecondOperand().accept(this);
    double v2 = stack.pop();
    switch (tree.getOperator()) {
    case Cadd:
      stack.push(v1 + v2);
      break;
    case Csubtract:
      stack.push(v1 - v2);
      break;
    case Cmultiply:
      stack.push(v1 * v2);
      break;
    case Cdivide:
      stack.push(v1 / v2);
      break;
    case Cmodulo:
      stack.push(v1 % v2);
    }
  }

  /**
   * PZq]B]ʂ̓C^v^
   * X^bN̐擪ɐς܂B
   * @param tree PZq̍\
   */
  public void caseUniExprTree(UniExprTree tree) {
    // Iyh]ăX^bNɃvbV
    tree.getOperand().accept(this);
    // X^bNIyh̒lo
    double val = stack.pop();
    switch (tree.getOperator()) {
    case Cadd:
      // Iyh̒lύXɃX^bNɃvbV
      stack.push(val);
      break;
    case Csubtract:
      // 𔽓]ĂX^bNɃvbV
      stack.push(-val);
    }
  }

  /**
   * ϐloBol̓C^v^
   * X^bN̐擪ɐς܂B
   * @param node ϐ̍\
   */
  public void caseVarNode(VarNode node) {
    if (node.isGlobal())
      stack.push(memory.getData(node.getLocation()));
    else
      stack.push(stack.getFrameElement(node.getLocation()));
  }

  /**
   * C^v^X^bN̐擪ɐςށB
   * @param node ̍\
   */
  public void caseNumNode(NumNode node) {
    stack.push(new Double((double)node.getValue()));
  }

  /**
   * ]B]ɂ蓾ꂽ^l̓C^v^
   * X^bN̐擪ɐς܂B
   * @param tree ̍\
   */
  public void caseCondTree(CondTree tree) {
    tree.getFirstOperand().accept(this);
    double v1 = stack.pop();
    tree.getSecondOperand().accept(this);
    double v2 = stack.pop();
    switch (tree.getOperator()) {
    case CgreaterThan:
      stack.push(v1 > v2 ? True : False);
      break;
    case ClessThan:
      stack.push(v1 < v2 ? True : False);
      break;
    case CgreaterThanOrEqual:
      stack.push(v1 >= v2 ? True : False);
      break;
    case ClessThanOrEqual:
      stack.push(v1 <= v2 ? True : False);
      break;
    case Cequal:
      stack.push(v1 == v2 ? True : False);
      break;
    case CnotEqual:
      stack.push(v1 != v2 ? True : False);
      break;
    }
  }

  // ľܓԂ
  private int rint(double d) {
    return (int)Math.floor(d + .5);
  }
}
