/*
 * 쐬: 2008/07/11
 * author: Taro Suzuki
 *
 * 葱Ăяô߂̍\؂̒`
 *
 */
package tgl.stree;

import java.util.ArrayList;

import tgl.interpreter.SystemProc;


/**
 * 葱Ăяô߂̍\؂̃NXB
 */
public class CallTree implements ExprTree {
  private String name;
  private ArrayList<ExprTree> args;
  private Code code = null;
  private SystemProc system = null;
  private boolean command;

  /**
   * [U`葱Ăяo̍\؂̃CX^X쐬B
   * @param name 葱
   * @param args ̌
   * @param code [U`葱̖{
   * @param stmt 葱R}hȂ trueA֐Ȃ false
   */
  public CallTree(String name, ArrayList<ExprTree> args, Code code, boolean stmt) {
    this.name = name;
    this.args = args;
    this.code = code;
    this.system = null;
    this.command = stmt;
  }

  /**
   * VXe`葱Ăяo̍\؂̃CX^X쐬B
   * @param name 葱
   * @param args ̌
   * @param system VXe`葱\CX^X
   * @param stmt 葱R}hȂ trueA֐Ȃ false
   */
  public CallTree(String name, ArrayList<ExprTree> args, SystemProc system, boolean stmt) {
    this.name = name;
    this.args = args;
    this.code = null;
    this.system = system;
    this.command = stmt;
  }

  /**
   * Ăяo葱̖O擾B
   * @return Ăяo葱̖O
   */
  public String getName() {
    return name;
  }

  /**
   * Xg擾B
   * @return XgɑΉ\؂̗
   */
  public ArrayList<ExprTree> getArguments() {
    return args;
  }

  /**
   * Ăяo葱̃R[h擾
   * @return Ăяo葱̃R[h
   */
  public Code getCode() {
    return code;
  }

  /**
   * Ăяo葱R}hł邩ǂ𔻒fB
   * @return R}hĂяoȂ trueA֐ĂяoȂ false
   */
  public boolean isCommand() {
    return command;
  }

  /**
   * Ăяo葱VXe`葱ǂ𔻒fB
   * @return VXe`葱Ȃ trueA[U`葱Ȃ false
   */
  public boolean isSystemProcedure() {
    return system != null;
  }

  /**
   * VXe`葱\NX̃CX^X擾B
   * @return VXe`葱\NX̃CX^X
   */
  public SystemProc getSystemProcedure() {
    return system;
  }

  /**
   * rW^NXɒ`ꂽ\bh caseCallTree ĂяoB
   */
  public void accept(STreeVisitor v) {
    v.caseCallTree(this);
  }

}
