%{
using namespace std;

#include <stdio.h>
#include <math.h>
#include <vector>
#include <string>
#include "code.h"
#include "symtable.h"
#include "error.h"
#include "const.h"


// ؿΥץȥ
int yyerror(char *msg);		// (error.ccѤ)
static CallTree *makeCallTree(string name,
                              ExprList *params,
                              ProcEntry *callee);

// Ūѿ
static Code *code;	// main()ιʸ
static ProcEntry *proc;	// return ǤηåΤˡ
			// ߽Ƥ³Υȥ¸
%}

%union{
  CConst op;		// 黻Ҥɽ
  string *symbol;	// ̻̾ؤΥݥ
  VarEntry *var;	// ѿȥؤΥݥ
  STree *tree;		// ʸڤؤΥݥ
  int num;		// 
  double constant;	// 
  Code *code;		// ֥ɤؤΥݥ
  CondList *condlist;	// ʸꥹȤΥڥؤΥݥ
  ExprList *exprlist;   // ؤΥݥ
  ExprTree *expression;	// ιʸڤؤΥݥ
  CondTree *condition;	// ιʸڤؤΥݥ
  int length;		// ꥹȤĹ
}
 
%token <symbol> ID
%token <num> NUM
%token VAR FUNC COMM
%token <op> ADDOP MULOP RELOP SIGNOP
%token IF ELSIF ELSE WHILE REPEAT RETURN

%type <constant> conExpr
%type <tree> stmt
%type <expression> expr
%type <condition> cond
%type <condlist> ifPart
%type <code> stmtList elsePart
%type <exprlist> argList argList2
%type <length> paramList paramList2 procDef

%left ADDOP
%left MULOP
%nonassoc SIGNOP

%%

// ץ   
program: declPart defPart { checkProgram(); }
       ;

//    |  
declPart:
        | declPart decl
	;

//   VAR ID ';' | VAR ID '='  ';' |
//         FUNC ID '@' NUM ';' | COMM ID '@' NUM ';'
decl: VAR ID ';'
      { addGlobalVariable(*$2)->setLocation(allocateMemory(*$2,0.0));
        delete $2; }
    | VAR ID '=' conExpr ';'
      { addGlobalVariable(*$2)->setLocation(allocateMemory(*$2,$4));
        delete $2; }
    | FUNC ID '@' NUM ';'  { addFunction(*$2,$4); delete $2; }
    | COMM ID '@' NUM ';'  { addCommand(*$2,$4);  delete $2; }
    ;

//    ADDOP  |  MULOP 
//         | SIGNOP  | '('  ')' | NUM
conExpr: conExpr ADDOP conExpr
         { switch ($2)  {
             case Cadd:      $$ = $1 + $3; break;
             case Csubtract: $$ = $1 - $3; break; } }
       | conExpr MULOP conExpr
         { switch ($2)  {
             case Cmultiply: $$ = $1 * $3; break;
             case Cdivide:   $$ = $1 / $3; break;
             case Cmodulo:   $$ = fmod($1,$3); } }
       | ADDOP conExpr %prec SIGNOP
         { $$ = ($1 == Cadd ? $2 : -$2); }
       | '(' conExpr ')'  { $$ = $2; }
       | NUM              { $$ = (double)$1; }
       ;

//    |  
defPart: definition
       | defPart definition
       ;

//   ؿ | ޥ
definition: funcDef
          | commDef
          ;

// ؿ  FUNC ID ³
funcDef: FUNC ID { proc = defineFunction(*$2); } procDef
         { ReturnTree *t = new ReturnTree(new NumNode(0),$4);
           proc->addCode(t); delete $2; }
       ;

// ޥ  COMM ID ³
commDef: COMM ID { proc = defineCommand(*$2); } procDef
         { ReturnTree *t = new ReturnTree(NULL,$4);
           proc->addCode(t); delete $2; }
       ;

// ³  '(' ꥹ ')' '{' ɽꥹ ʸꥹ '}'
procDef: '(' paramList ')' { checkParamNumber($2,proc); }
         '{' localDeclList { code = proc->getCode(); }
             stmtList '}'  { $$ = $2; }
       ;

// ꥹ   | ꥹȡ
paramList: /* empty */ { $$ = 0; }
         | paramList2
         ;

// ꥹȡ   | ꥹȡ',' 
paramList2: param  { $$ = 1; }
          | paramList2 ',' param  { $$ = $1 + 1; }
          ;

//   ID
param: ID  { addParameter(*$1); }
     ;

// ɽꥹ   | ɽꥹ ɽ
localDeclList: /* empty */
             | localDeclList localDecl
             ;

// ɽ  VAR ID ';' | VAR ID '='  ';'
localDecl: VAR ID ';'
           { addLocalVariable(*$2);
             proc->addCode(new LocalVarTree(*$2,NULL));
             delete $2; }
         | VAR ID '=' expr ';'
           { addLocalVariable(*$2);
             proc->addCode(new LocalVarTree(*$2,$4));
             delete $2; }
         ;

// ʸꥹ   | ʸꥹ ʸ
stmtList: /* empty */ { $$ = code; }
        | stmtList stmt { $1->push_back($2); $$ = $1; }
        ;

// ʸ  ID '='  | if else | WHILE '('  ')' '{' ʸꥹ '}' |
//       REPEAT '('  ')' '{' ʸꥹ '}' | ID '(' °ꥹ ')' ';' |
//       RETURN ';' | RETURN  ';'
stmt: ID  { $<var>$ = findVariable(*$1); }
      '=' expr ';'
      { VarNode *v = new VarNode(*$1,
                                 $<var>2->getLocation(),
                                 $<var>2->isGlobalVariable());
        $$ = new AssignTree(v,$4);
        delete $1;  }
    | ifPart elsePart { $$ = new IfTree($1,$2); }
    | WHILE '(' cond ')' '{'  { code = new Code; }
      stmtList '}'            { $$ = new WhileTree($3,$7); }
    | REPEAT '(' expr ')' '{' { code = new Code; }
      stmtList '}'            { $$ = new RepeatTree($3,$7); }
    | ID '(' argList ')' ';'
      { $$ = makeCallTree(*$1,$3,findCommand(*$1)); delete $1; }
    | RETURN ';'
      { if (proc->isFunction())
          compileError(ENotReturnValue,proc->getName().c_str());
        $$ = new ReturnTree(NULL,proc->getParamNumber()); }
    | RETURN expr ';'
      { if (proc->isCommand())
          compileError(EReturnValue,proc->getName().c_str());
        $$ = new ReturnTree($2,proc->getParamNumber()); }
    ;

// if  IF '('  ')' '{' ʸꥹ '}' | 
//	   if ELSIF '('  ')' '{' ʸꥹ '}'
ifPart: IF '(' cond ')' '{' { code = new Code; }
        stmtList '}'
        { $$ = new CondList; $$->push_back(make_pair($3,$7)); }
      | ifPart ELSIF '(' cond ')' '{' { code = new Code(); }
        stmtList '}'  { $$->push_back(make_pair($4,$8)); }
      ;

// else  ELSE '{' ʸꥹ '}'
elsePart: /* empty */  { $$ = NULL; }
        | ELSE '{'     { code = new Code(); }
          stmtList '}' { $$ = $4; }
        ;

//    ADDOP  |  MULOP  | SIGNOP  | '('  ')' | ID | NUM
expr: expr ADDOP expr { $$ = new BinExprTree($2,$1,$3); }
    | expr MULOP expr { $$ = new BinExprTree($2,$1,$3); }
    | ADDOP expr %prec SIGNOP
      { $$ = new UniExprTree($1,$2); }
    | '(' expr ')'    { $$ = $2; }
    | ID '(' argList ')'
      { $$ = makeCallTree(*$1,$3,findFunction(*$1)); delete $1; }
    | ID { VarEntry *v = findVariable(*$1);
           $$ = new VarNode(*$1,v->getLocation(),v->isGlobalVariable());
           delete $1; }
    | NUM  { $$ = new NumNode($1); }
    ;

// °ꥹ   | °ꥹȡ
argList: /* empty */ { $$ = NULL; }
       | argList2    { $$ = $1; }
       ;

// °ꥹȡ   | °ꥹȡ ',' 
argList2: expr	{ $$ = new ExprList; $$->push_back($1); }
        | argList2 ',' expr  { $$ = $1; $$->push_back($3); }
        ;

//    RELOP 
cond: expr RELOP expr { $$ = new CondTree($2,$1,$3); }
    ;

%%

static CallTree *makeCallTree(string name,
                              ExprList *params, ProcEntry *callee)
{
  int paramNum = (params == NULL) ? 0 : params->size();
  checkParamNumber(paramNum,callee);
  if (callee->isUserDefined())
    return new CallTree(name,params,callee->getCode());
  else  {
    SystemProc sysProc = callee->getSystemProcedure();
    return new CallTree(name,params,sysProc);
  }
}

void usage(char *cmd)
{
  fprintf(stderr,"ˡ: %s ϥץե̾\n",cmd);
  exit(2);
}

main(int argc, char **argv)
{
#if YYDEBUG
  extern int yydebug;
#endif
  Code *code;

  char *cmd = *argv;	// ѥΥޥ̾

  if (argc < 2) usage(cmd);

  /* ǽΰץ󤫡 */
  while (**++argv == '-')  {
    argc--;
    switch (*(*argv+1))  {
    case 's':
      setSpeed(atoi(*argv+2));
      break;
    default:
      printf("̵ʥץ -%s\n",*argv);
    }
  }
  if (argc <= 0) usage(cmd);

#if YYDEBUG
  yydebug = 1;	/* ǥХåɽդιʸϷϤȤ 1  */
#endif

  setFileName(*argv);
  initializeScanner(*argv);
  initializeSymbolTable();
  yyparse();
  code = findCommand("main")->getCode();
  clearSymbolTable();
  initializeInterpreter();
  interpret(code);
}
