/****************************************************************
   interpreter.cc  ʸڤ¹Ԥ륤󥿥ץ꥿

****************************************************************/

using namespace std;

#include <math.h>
#include <utility>
#include <vector>
#include <string>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "code.h"
#include "const.h"
#include "system.h"

// ̾ machine
namespace machine  {
const int StackSize = 8192;		// å礭
const int InitialSP = 1;		// åݥ󥿤ν
vector<pair<string,double> > Data;	// Ūǡΰ
double stack[StackSize];		// å
int sp;					// åݥ
int fp;					// ե졼ݥ
}


// ̵̾̾֡ʤΥեͭ
namespace {
bool interpretCode(Code *code);
void interpretAssign(AssignTree *assignTree);
bool interpretIf(IfTree *ifTree);
bool interpretWhile(WhileTree *whileTree);
bool interpretRepeat(RepeatTree *repeatTree);
void interpretCall(CallTree *callTree);
bool interpretReturn(ReturnTree *returnTree);
void interpretLocalVar(LocalVarTree *lvarTree);

double evaluateExpression(ExprTree *expr);
int evaluateCondition(CondTree *cond);

}	// ̵֤̾̾ν


// Хؿ

void initializeInterpreter()
{
  machine::sp = machine::InitialSP;
  machine::fp = 0;
}

int allocateMemory(string name, double val)
{
  machine::Data.push_back(make_pair(name,val));
  return machine::Data.size()-1;
}

void interpret(Code *code)
{
  XEvent e;
  int black, white;

  using namespace systemFuncLib;
  using namespace machine;

  display = XOpenDisplay(NULL);
  black = BlackPixel(display,0);
  white = WhitePixel(display,0);
  window = XCreateSimpleWindow(display,RootWindow(display,0),
			       100,100,WindowXSize,WindowYSize,2,black,white);
  gc = XCreateGC(display,window,0,0);
  initializeColorTable();
  XSelectInput(display,window,ExposureMask | ButtonPressMask | KeyPressMask);
  XMapWindow(display,window);
  while (1)  {
    XNextEvent(display,&e);
    if (e.type == Expose)  {
      // ȥΰ֤
      initializeTurtle();
      // åݥ󥿤
      sp = InitialSP;
      interpretCode(code);
    }
    if (e.type == ButtonPress)
      break;
  }
  XCloseDisplay(display);
}

// ̵̾̾֡ʤΥեͭ
namespace {

using namespace machine;


bool interpretCode(Code *code)
{
  bool returnNow = false;

  // code  NULL ʤ鲿⤷ʤ
  if (code == NULL) return returnNow;

  Code::iterator it, ie = code->end();
  for (it = code->begin(); it != ie && !returnNow; it++)  {
    switch ((*it)->getID())  {
    case Sassign:
      interpretAssign((AssignTree *)(*it));
      break;
    case Sif:
      returnNow = interpretIf((IfTree *)(*it));
      break;
    case Swhile:
      returnNow = interpretWhile((WhileTree *)(*it));
      break;
    case Srepeat:
      returnNow = interpretRepeat((RepeatTree *)(*it));
      break;
    case Sexpr:	// ̤ Sexpr ǤʸϥޥɸƤӽФ
      interpretCall((CallTree *)(*it));
      break;
    case Sreturn:
      returnNow = interpretReturn((ReturnTree *)(*it));
      break;
    case SlocalVar:
      interpretLocalVar((LocalVarTree *)(*it));
    }
  }
  return returnNow;
}

void interpretAssign(AssignTree *assignTree)
{
  double result = evaluateExpression(assignTree->getExpression());
  int loc = assignTree->getLocation();
  bool global = assignTree->isGlobal();
  if (global)  {
    Data[loc].second = result;
  }
  else  {
    stack[fp+loc] = result;
  }
}

bool interpretIf(IfTree *ifTree)
{
  bool returnNow = false;
  CondList *condList = ifTree->getCondList();
  CondList::iterator it, ie=condList->end();

  for (it=condList->begin(); it != ie && !returnNow; it++)  {
    if (evaluateCondition(it->first))
      break;
  }
  if (it != ie)
    // elseΤ郎ˤʤäΤбʸꥹȤ¹
    returnNow = interpretCode(it->second);
  else
    // else᤬Ф¹
    returnNow = interpretCode(ifTree->getElsePart());

  return returnNow;
}

bool interpretWhile(WhileTree *whileTree)
{
  bool returnNow = false;
  CondTree *cond = whileTree->getCondition();
  Code *body = whileTree->getBody();

  //  cond δ body ¹
  while (evaluateCondition(cond))
    returnNow = interpretCode(body);

  return returnNow;
}

bool interpretRepeat(RepeatTree *repeatTree)
{
  bool returnNow = false;
  Code *body = repeatTree->getBody();

  // 롼פ¹Ԥ뤫ꤹ뼰ɾơ롼פμ¹Բ
  int count = (int)rint(evaluateExpression(repeatTree->getCount()));
  // ꤵ줿¹ԲΤ¹Ԥ롣
  while (count-- > 0)
    returnNow = interpretCode(body);

  return returnNow;
}

void interpretCall(CallTree *callTree)
{
  // °ФƬɾƥå˥ץå夹
  ExprList *args = callTree->getArguments();
  if (args != NULL)  {
    ExprList::iterator it, ie = args->end();
    for (it=args->begin(); it != ie; it++)  {
      // G++ 3ϤǤϱͤɾˡդsp++¹ԤƤޤ
      // G++ 2ϤǤϱͤˡդsp++¹Ԥ
      stack[sp] = evaluateExpression(*it);
      sp++;		
    }
  }
  // 桼³ƥ³Ƚ
  SystemProc system = callTree->getSystemProcedure();
  if (system == NULL)  {
    // 桼³
    stack[sp] = (double)fp;		// ե졼ݥ󥿤
    fp = sp++;				// ե졼ݥ󥿤ι
    interpretCode(callTree->getCode());	// ³Τμ¹
  }
  else  {
    // ƥ³
    system();				// ƥ³θƽФ
  }
}

bool interpretReturn(ReturnTree *returnTree)
{
  // ֤֤ͤɬפʤ顢ɾ֤ͤ
  ExprTree *expr = returnTree->getExpression();
  double result;
  if (expr != NULL)  {
    result = evaluateExpression(expr);
  }
  // ե졼ʲΰޤˤβ
  sp = fp;		  // ɽѿΰȥե졼ݥ󥿤
  fp = (int)stack[fp];	  // ե졼ݥ󥿤Υե졼ؤ褦ˤ
  sp -= returnTree->getParamNumber();	// ΰβ
  // ֤֤ͤɬפʤ顢åƬ֤ͤץå夹
  if (expr != NULL)
    stack[sp++] = result;
  // true ֤б³ƽФޤ褦ˤ
  return true;
}

void interpretLocalVar(LocalVarTree *lvarTree)
{
  // ɬפʤ顢åݥ󥿤ؤƤΰ˽ͤ򥻥åȤ
  ExprTree *expr = lvarTree->getExpression();
  if (expr)  {
    double result = evaluateExpression(expr);
    stack[sp] = result;
  }
  // åݥ󥿤ͤҤȤ䤹
  sp++;
}

double readStaticMemory(int loc)
{
  return Data[loc].second;
}

double evaluateExpression(ExprTree *expr)
{
  switch (expr->getID())  {
  case ETbinop:
  { double val1 = evaluateExpression(((BinExprTree *)expr)->getFirstOperand());
    double val2 = evaluateExpression(((BinExprTree *)expr)->getSecondOperand());
    
    switch (((BinExprTree *)expr)->getOperator())  {
    case Cadd:
      return val1 + val2;
    case Csubtract:
      return val1 - val2;
    case Cmultiply:
      return val1 * val2;
    case Cdivide:
      return val1 / val2;
    case Cmodulo:
      return fmod(val1,val2);
    default:
      fprintf(stderr,"¹Ի顼: ɾ̤黻ҤФޤ !!\n");
      exit(2);
    }
  }
  case ETuniop:
  { double val = evaluateExpression(((UniExprTree *)expr)->getOperand());
    CConst op = ((UniExprTree *)expr)->getOperator();
    if (op == Csubtract)
      return -val;
    else if (op == Cadd)
      return val;
    else  {
      fprintf(stderr,"¹Ի顼: ɾ̤椬Фޤ !!\n");
      exit(2);
    }
  }
  case ETcall:
    interpretCall((CallTree *)expr);
    // ֤ͤ򥹥åƬݥåפ
    return stack[--sp];
  case ETvar:
    if (((VarNode *)expr)->isGlobal())
      return readStaticMemory(((VarNode *)expr)->getLocation());
    else
      return stack[fp+((VarNode *)expr)->getLocation()];
  case ETnum:
    return (double)((NumNode *)expr)->getValue();
  default:
    fprintf(stderr,"¹Ի顼: ɾǡǤϤʤΤ򸡽Фޤ !!\n");
    exit(2);
  }
}

int evaluateCondition(CondTree *cond)
{
  double val1 = evaluateExpression(cond->getFirstOperand());
  double val2 = evaluateExpression(cond->getSecondOperand());
    
  switch (cond->getOperator())  {
  case CgreaterThan:
    return val1 > val2;
  case ClessThan:
    return val1 < val2;
  case CgreaterThanOrEqual:
    return val1 >= val2;
  case ClessThanOrEqual:
    return val1 <= val2;
  case Cequal:
    return val1 == val2;
  case CnotEqual:
    return val1 != val2;
  default:
    fprintf(stderr,"illegal operator !!\n");
    exit(2);
  }
}


}	// ̵֤̾̾ν
